'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Public Sub RechnungZumDrucker()
    Dim ZeitDifferenz As Single

    On Error GoTo ERR_Formular                  'bei fehlendem Formular den Standard nehmen
    'Rechnungsformular ("anzeigen") drucken
    DoCmd.OpenReport FormularRechnungName, acPreview
ERR_Formular_weiter:
    Application.Echo True
    On Error GoTo ERR_Formular_zeichnen         'bei fehlendem Formular den Standard nehmen
    DoCmd.RepaintObject acReport, FormularRechnungName
    DoCmd.RepaintObject acReport, FormularRechnungName
ERR_Formular_zeichnen_weiter:
    'Fehlerbehandlung ausschalten, damit beim Druckabbruch keine Fehlermeldung erscheint
    On Error Resume Next
    DoCmd.PrintOut
    On Error GoTo ERR_Formular_schliessen       'bei fehlendem Formular den Standard nehmen
    DoCmd.Close acReport, FormularRechnungName, acSaveNo
ERR_Formular_schliessen_weiter:
    
    
    'Druckpause bei "Serien"-Druck bercksichtigen
    On Error GoTo EXIT_Pause
    If Verzoegerung > 0 Then
        DoCmd.OpenForm "Bitte_warten_Druckpause"
        Forms![Bitte_warten_Druckpause].Repaint
        ZeitDifferenz = 0
        VerzoegerungStart = Fix(Timer)
        VerzoegerungEnde = Fix(Timer)
        Do While Verzoegerung > ((VerzoegerungEnde - VerzoegerungStart))
            'Anzeige nur aktualisieren, wenn sich der Sekundenwert gendert hat
            If ZeitDifferenz <> (Verzoegerung - (VerzoegerungEnde - VerzoegerungStart)) Then
                ZeitDifferenz = (Verzoegerung - (VerzoegerungEnde - VerzoegerungStart))
                Forms![Bitte_warten_Druckpause]![Wartetext].Caption = Verzoegerung - (VerzoegerungEnde - VerzoegerungStart)
                Forms![Bitte_warten_Druckpause].Repaint
            End If
            'auf Ereignisse reagieren (und Druckerwarteschlange bedienen)
            DoEvents
            'aktuellen Sekundenwert holen
            VerzoegerungEnde = Fix(Timer)
        Loop
        DoCmd.Close acForm, "Bitte_warten_Druckpause", acSaveNo
    End If
        
EXIT_der_Sub:
    Exit Sub

EXIT_Pause:
    Resume EXIT_der_Sub
    
ERR_Formular:
    DoCmd.OpenReport "Rechnung_Hauptformular", acPreview
    Resume ERR_Formular_weiter
    
ERR_Formular_zeichnen:
    DoCmd.RepaintObject acReport, "Rechnung_Hauptformular"
    DoCmd.RepaintObject acReport, "Rechnung_Hauptformular"
    Resume ERR_Formular_zeichnen_weiter
    
ERR_Formular_schliessen:
    DoCmd.Close acReport, "Rechnung_Hauptformular", acSaveNo
    Resume ERR_Formular_schliessen_weiter

End Sub

Public Sub RechnungenDrucken()
    Dim stDocName As String
    Dim stLinkCriteria As String
    
    Dim i, j As Long
    Dim dbs As Database
    Dim rst As Recordset, qdf As QueryDef
    Dim strFilterRechnung, strFilterKunde As String
    
    'Datenbankumgebung festlegen
    Set dbs = CurrentDb
    
    'Rechnungstabelle ffnen
    If (ReUngedrucktAlle = True) Then
        FilterRechnungen = "SELECT * FROM Rechnungen WHERE ([gedruckt] = False)"
    Else
        If (ReLaufArt = 1) Or (ReLaufArt = 4) Then
            'Normaler Rechnungslauf (oder Generalrckrechnung)
            FilterRechnungen = "SELECT * FROM Rechnungen WHERE (([gedruckt] = False)" & _
                " AND ([lfd_Nr_ReLauf] = " & rstRechnungslaeufe!lfd_Nr & "))"
        End If
        If (ReLaufArt = 2) Or (ReLaufArt = 5) Then
            'Rechnungen nur genieren und speichern (oder Kalkulationslauf)
            FilterRechnungen = "SELECT * FROM Rechnungen WHERE ([lfd_Nr_ReLauf] = 0)"
        End If
        If ReLaufArt = 3 Then
            'Wiederholungsdruck einzelner Rechnungslauf
            If ReDruckWdhUngedruckt = True Then
                FilterRechnungen = "SELECT * FROM Rechnungen WHERE (([lfd_Nr_ReLauf] = " & ReLaufnummer & _
                    ") AND ([gedruckt] = False))"
            Else
                FilterRechnungen = "SELECT * FROM Rechnungen WHERE ([lfd_Nr_ReLauf] = " & ReLaufnummer & ")"
            End If
        End If
    End If
    Set rstRechnungen = dbs.OpenRecordset(FilterRechnungen)
    If (rstRechnungen.RecordCount <> 0) Then
        rstRechnungen.MoveLast
    Else
        MsgBox "Die von Ihnen getroffene Auswahl ergab keine zu druckende Rechnung(en).", vbInformation, "Hinweis"
        rstRechnungen.Close
        'Set dbs = Nothing
        Exit Sub
    End If
    
    'Fortschrittsdialog auf den Schirm bringen
    DoCmd.OpenForm "Rechnungsdruck"
    
    NummeroGesamt = rstRechnungen.RecordCount
    NummeroRechnung = 0
    'alle zu druckenden Rechnungen durchgehen
    rstRechnungen.MoveFirst
    Do While (rstRechnungen.EOF = False)
        'Zhler und Anzeige aktualisieren
        NummeroRechnung = NummeroRechnung + 1
        ShowProgress Forms!Rechnungsdruck.Verlauf_Balken, NummeroRechnung - 1, NummeroGesamt
        'Nach Kontaktdetails suchen
        FilterKontakt = "SELECT * FROM Kunden WHERE [lfd_Nr] = " & rstRechnungen!lfd_Nr_Kunde
        Set rstKontakte = dbs.OpenRecordset(FilterKontakt)
            Forms!Rechnungsdruck.Re_Kunde.Caption = rstKontakte!Name1
        rstKontakte.Close
        Forms!Rechnungsdruck.Re_Rechnungsnummer.Caption = rstRechnungen!Re_Nr
        Forms!Rechnungsdruck.Re_Betrag.Caption = Format(rstRechnungen!Re_Brutto, "#,##0.00")
        Forms!Rechnungsdruck.Repaint
        'SQL-Texte vorbereiten
        strFilterRechnung = "SELECT * FROM Rechnungen WHERE Rechnungen.lfd_Nr=" & rstRechnungen!lfd_Nr
        strFilterKunde = "SELECT * FROM Kunden WHERE Kunden.lfd_Nr=" & rstRechnungen!lfd_Nr_Kunde
        'vorhandene Abfragen erst lschen und mit neuem SQL-Text erstellen
        dbs.QueryDefs.Refresh
        On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
        dbs.QueryDefs.Delete "Abf_RechnungDaten"
        Set qdf = dbs.CreateQueryDef("Abf_RechnungDaten", strFilterRechnung)
        dbs.QueryDefs.Delete "Abf_RechnungKunde"
        Set qdf = dbs.CreateQueryDef("Abf_RechnungKunde", strFilterKunde)
        dbs.QueryDefs.Refresh
        'Rechnung ausdrucken
        ReOriginal = True
        RechnungZumDrucker
        'Markierung und Datum setzen und Ansicht aktualisieren
        If rstRechnungen!gedruckt <> True Then
            'nur beim ersten Druck dieser Rechnung das Datum merken
            rstRechnungen.Edit
            rstRechnungen!gedruckt = True
            rstRechnungen!Re_Druckdatum = Now()
            rstRechnungen.Update
            'bearbeiteten Datensatz wieder zum aktuellen Satz machen
            rstRechnungen.Bookmark = rstRechnungen.LastModified
        End If
        If (ReKopieZeitpunkt = 0) And (ReKopieAnzahl > 0) Then
            'Rechnungskopie zum Original drucken
            ReOriginal = False
            For i = 1 To ReKopieAnzahl Step 1
                RechnungZumDrucker
            Next i
        End If
        'Tabellen schlieen
        qdf.Close
        'zur nchsten Rechnung
        rstRechnungen.MoveNext
    Loop                'alle Rechnungen durchgehen
    
    If (ReKopieZeitpunkt = 1) And (ReKopieAnzahl > 0) Then
        'Rechnungskopien gesammelt am Ende drucken
        NummeroRechnung = 0
        'alle zu druckenden Rechnungen durchgehen
        rstRechnungen.MoveFirst
        Do While (rstRechnungen.EOF = False)
            'Zhler und Anzeige aktualisieren
            NummeroRechnung = NummeroRechnung + 1
            ShowProgress Forms!Rechnungsdruck.Verlauf_Balken, NummeroRechnung - 1, NummeroGesamt
            'Nach Kontaktdetails suchen
            FilterKontakt = "SELECT * FROM Kunden WHERE [lfd_Nr] = " & rstRechnungen!lfd_Nr_Kunde
            Set rstKontakte = dbs.OpenRecordset(FilterKontakt)
                Forms!Rechnungsdruck.Re_Kunde.Caption = rstKontakte!Name1
            rstKontakte.Close
            Forms!Rechnungsdruck.Re_Rechnungsnummer.Caption = rstRechnungen!Re_Nr
            Forms!Rechnungsdruck.Re_Betrag.Caption = rstRechnungen!Re_Brutto
            Forms!Rechnungsdruck.Repaint
            'SQL-Texte vorbereiten
            strFilterRechnung = "SELECT * FROM Rechnungen WHERE Rechnungen.lfd_Nr=" & rstRechnungen!lfd_Nr
            strFilterKunde = "SELECT * FROM Kunden WHERE Kunden.lfd_Nr=" & rstRechnungen!lfd_Nr_Kunde
            'vorhandene Abfragen erst lschen und mit neuem SQL-Text erstellen
            dbs.QueryDefs.Refresh
            On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
            dbs.QueryDefs.Delete "Abf_RechnungDaten"
            Set qdf = dbs.CreateQueryDef("Abf_RechnungDaten", strFilterRechnung)
            dbs.QueryDefs.Delete "Abf_RechnungKunde"
            Set qdf = dbs.CreateQueryDef("Abf_RechnungKunde", strFilterKunde)
            dbs.QueryDefs.Refresh
            'Rechnung ausdrucken
            ReOriginal = False
            For i = 1 To ReKopieAnzahl Step 1
                RechnungZumDrucker
            Next i
            'Tabellen schlieen
            qdf.Close
            'zur nchsten Rechnung
            rstRechnungen.MoveNext
        Loop                'alle Rechnungen durchgehen
    End If                  'Rechnungskopien gesammelt am Ende drucken
    
    'Fortschrittsdialog wieder schlieen
    DoCmd.Close acForm, "Rechnungsdruck", acSaveYes
    
    'Tabellen wieder schlieen
    rstRechnungen.Close
    'Set dbs = Nothing
    
End Sub

Public Sub Re_von_bis_vermerken()
    'zur Rechnung selbst "Von-" und "Bis-" -Monat auf den tatschlichen ersten/letzten BERECHNETEN
    '   Termin einstellen, da dieser vom gewhlten von-/bis-Zeitraum abweichen kann.
    '   Grund: Auf der Rechnung soll der von-/bis-Zeitraum mit den Rechnungsdaten bereinstimmen!
    If (ReTestlauf = False) Then        'nur beim Echtlauf
        rstRechnungen.Edit
            'von-Monat nur beim ersten tatschlich berechneten Termin einstellen;
            '   also nur bei neuer Rechnung
            If (ReNeu2 = True) Then
                rstRechnungen!Re_von = "01." & Format(ReMonat, "00") & "." & ReJahr
                ReNeu2 = False
            End If
            'letzten Tag des letzten tatschl. Monats der berechneten Termine immer ermitteln
            If ReMonat = 12 Then
                rstRechnungen!Re_bis = "01.01." & (ReJahr + 1)                              'auf 1.1. des nchsten Jahres
            Else
                rstRechnungen!Re_bis = "01." & Format(ReMonat + 1, "00") & "." & ReJahr     'auf den 1. des nchsten Monats
            End If
            rstRechnungen!Re_bis = rstRechnungen!Re_bis - 1                                 'der letzte Tag von Monat_bis
        rstRechnungen.Update
        'nach dem Speichern, den Datensatzzeiger wieder auf diesen Satz stellen...
        rstRechnungen.Bookmark = rstRechnungen.LastModified
    End If
End Sub

Public Sub MatrixRechnungslegung()
    
    Dim MonatsLetzterTag As Integer

    'Die Matrix darf nur bis Monatsletzten durchlaufen werden, weil bei weniger als 30 Tagen, bei Terminen
    'ber das Monatsende nach dem Monatsletzten die Abrechnungsdaten mit den "Zwischentagen" gefllt werden,
    'die zwar den an diesen Tagen gltigen Stundensatz enthalten, aber 0 Minuten und 0 Betrag enthalten.
    'letzten Tag ermitteln...
    MonatsLetzterTag = 31
    'wenn das Terminende nach dem aktuellen Berechnungsmonat liegt
    If (rstTermine!E_Jahr > ReJahr) Or ((rstTermine!E_Jahr = ReJahr) And (rstTermine!E_Monat > ReMonat)) Then
        'letzten Tag des Monats ermitteln und Matrix darauf einstellen
        If ReMonat = 12 Then
            MatrixDatum = "01.01." & (ReJahr + 1)
        Else
            MatrixDatum = "01." & Format(ReMonat + 1, "00") & "." & ReJahr
        End If
        MonatsLetzterTag = Day(MatrixDatum - 1)
    Else
        'Terminende liegt im akt. Monat
        MonatsLetzterTag = rstTermine!E_Tag
    End If

    'Werte auf 0 (Null) setzen
    ReDauerBerechnet = 0
    ReStdSatzNetto = 0
    ' ReNettoBisher = 0     ReNettoBisher hier noch nicht auf Null setzen!
    ReTerminNetto = 0
    'Datenstze fr die Rechnung bilden ----------------------------------------------------
    MatrixTag = 1
    'wenn Terminbeginn im aktuellen Berechnungsmonat liegt, den Starttag fr die Matrix aus dem Terminbeginn nehmen
    If ((rstTermine!S_Jahr = ReJahr) And (rstTermine!S_Monat = ReMonat)) Then
        MatrixTag = rstTermine!S_Tag
    End If
    For MatrixTag = MatrixTag To MonatsLetzterTag Step 1
        'wenn Terminende berschritten: Schleife sofort verlassen
        If ((rstTermine!E_Jahr = ReJahr) And (rstTermine!E_Monat = ReMonat) And (MatrixTag > rstTermine!E_Tag)) Then
            Exit For
        End If
        If (MatrixTag = 1) Then
            'fr den Matrixbeginn, d.h. der Termin beginnt entweder am 1. des aktuellen Berechnungsmonats, oder
            '   vor dem akt. Berechnungsmonat und reicht in diesen hinein
            ReDauerBerechnet = NettoMatrix(MatrixTag, 2)
            ReStdSatzNetto = NettoMatrix(MatrixTag, 1)
            ReTerminNetto = NettoMatrix(MatrixTag, 3)
        Else
            If (NettoMatrix(MatrixTag - 1, 2) = 0) Then
                'bis zum Terminbeginn, nur akt. Tag merken (an den Vortagen ist der Betrag = 0)
                ReDauerBerechnet = NettoMatrix(MatrixTag, 2)
                ReStdSatzNetto = NettoMatrix(MatrixTag, 1)
                ReTerminNetto = NettoMatrix(MatrixTag, 3)
            Else
                'fr die restlichen Tage der Matrix
                If (NettoMatrix(MatrixTag, 1) = NettoMatrix(MatrixTag - 1, 1)) And (NettoMatrix(MatrixTag - 1, 2) > 0) Then
                    'wenn Std-Satz des Vortages gleich des akt. Tages, und auch nicht Terminbeginn
                    ReDauerBerechnet = ReDauerBerechnet + NettoMatrix(MatrixTag, 2)
                    ReTerminNetto = ReTerminNetto + NettoMatrix(MatrixTag, 3)
                Else
                    'An diesem Punkte angekommen, wurde die Matrix bis zu einer Preisnderung oder dem Terminende oder
                    '   dem Matrixende durchlaufen.
                    '   Die Nettowerte der durchlaufenen Tage wurden addiert und knnen im Folgenden in eine Rechnungszeile
                    '   geschrieben werden.
                    'Bisher Berechnetes bercksichtigen (hier nur beim ersten Re-TerminDatensatz, da nach der ersten
                    '   Rechnungszeile des Termins "ReNettoBisher" auf 0 gesetzt werden)
                    
                    'Achtung: An dieser Stelle "ReKmNettoBisher" NICHT abziehen, da "ReTerminNetto" nur fr
                    '   den eigentlichen Termin (Zeitdauer) vorgesehen ist, nicht fr den Km-Anteil!
                    ReTerminNetto = ReTerminNetto - ReNettoBisher
                    
                    
                    If ReTerminMonatssplitting = True Then
                        'Bei Termin mit Gebhr- oder Monatswechsel: ENDE(!) fr Rechnungsdetails anpassen
                        '   START(!) nach dem Schreiben der Rechnungsdetails anpassen...
                        '   ...auer, wenn Monat = 01 und START im Vorjahr liegt.
                        If (NettoMatrix(MatrixTag, 1) <> NettoMatrix(MatrixTag - 1, 1)) Then
                            'bei Gebhrwechsel: Prfen, ob evtl. auch Termin-ENDE vorliegt?
                            If (rstTermine!E_Jahr > ReJahr) Or ((rstTermine!E_Jahr = ReJahr) And (rstTermine!E_Monat > ReMonat)) _
                                Or ((rstTermine!E_Jahr = ReJahr) And (rstTermine!E_Monat = ReMonat) And (rstTermine!E_Tag > (MatrixTag - 1))) Then
                                'vorheriger Matrixtag ist ungleich Termin-Ende...
                                '---> Gebhrenwechsel, aber letzter Matrixtag ist nicht Termin-ENDE:
                                '   Termin-Ende fr Rechnungsdetails auf 23:59 des letzten Matrixtages plus 1 Sekunde einstellen und
                                '   Termin-Dauer mit aktueller (berechneter) Dauer fllen
                                ReDetailsTerminEnde = Format((MatrixTag - 1), "00") & "." & Format(ReMonat, "00") & "." & ReJahr & " 23:59:59"
                                ReDetailsTerminEnde = ReDetailsTerminEnde + 0.000012
                                ReDetailsTerminDauer = ReDauerBerechnet
                                ReDetailsTerminAngepasst = True         'Markierung, um START weiter unten anzupassen
                            End If          'Prfung von Termin-Ende
                        End If              'Prfung, ob Gebhr sich zum Vortag unterscheidet
                        'wenn Monat = 1 und START des Termines davor liegt, dann 1.1. als Start fr Rechnungsdetails
                        If (ReMonat = 1) And (rstTermine!S_Jahr < ReJahr) Then
                            ReDetailsTerminStart = "01.01." & ReJahr
                        End If
                        'wenn der Terminbeginn VOR dem ersten Monat des RechnunsZEITRAUMES liegt, und der aktuelle Monat
                        'der erste Monat des Rechnungszeitraumes ist, und der Terminbeginn noch nicht angepasst wurde
                        '(d.h. ReDetailsTerminStart noch kleiner als 00:00 des 1. des akt. Rechnungsmonats ist!),
                        'dann den 1. des aktuellen Monats mit 00:00 als Terminbeginn auf der Re-Zeile eintragen
                        If (ReMonat = ReMonatVon) And (CDate(ReDetailsTerminStart) < CDate("01" & "." & Format(ReMonat, "00") & "." & ReJahr & " 00:00:00")) Then
                            ReDetailsTerminStart = CDate("01" & "." & Format(ReMonat, "00") & "." & ReJahr & " 00:00:00")
                        End If
                    End If
                    
                    
                    'Die km-Berechnung erfolgt immer auf den Terminbeginn!
                    'Wenn der Terminbeginn im aktuellen Berechnungsmonat liegt, die km-Rechnungszeile noch
                    '   nicht erstellt wurde, und die km-Abrechnungsparameter eine BERECHNUNG vorsehen,
                    '   dann aktuellen km-Betrag ermitteln und bisher berechnetes km-Netto verrechnen.
                    If ReKmRechnungszeile = False Then
                        If km_Erfassung = True And km_Verwendungen = 2 Then
                            If rstTermine!S_Jahr = ReJahr And rstTermine!S_Monat = ReMonat Then
                                'Die ffnung der Tabelle erfolgte bereits zu Beginn des Rechnungslaufs
                                '   FilterKmPreis = "SELECT * FROM Km_Preise ORDER BY gilt_ab DESC;"
                                '   Set rstKmPreise = dbs.OpenRecordset(FilterKmPreis)
                                '   If rstKmPreise.RecordCount <> 0 Then
                                '       'Recordset auffllen
                                '       rstKmPreise.MoveLast
                                '       rstKmPreise.MoveFirst
                                '   End If
                                
                                'Ermittlung des gltigen Preises am Tag des Terminbeginns
                                If rstKmPreise.RecordCount = 0 Then
                                    'wenn die Preistabelle leer ist
                                    ReKmEinzPreis = 0
                                Else
                                    'wenn Preise vorhanden sind
                                    rstKmPreise.MoveFirst
                                    FilterKmPreis = "[gilt_ab] <= #" & Format(rstTermine!Start, "mm") & "/" & Format(rstTermine!Start, "Dd") & "/" & Format(rstTermine!Start, "yy") & "#"
                                    rstKmPreise.FindFirst FilterKmPreis
                                    If rstKmPreise.NoMatch Then
                                        'zu diesem Terminbeginn existierte noch kein Preis
                                        ReKmEinzPreis = 0
                                    Else
                                        ReKmEinzPreis = rstKmPreise!Preis
                                    End If
                                End If
                                'km * Preis - bereitsBerechnetes
                                'Mit CCur(Format(.. wird der ermittelte Wert auf 2 Nachkommastellen gerundet!
                                'ACHTUNG:
                                'Rundung negativer Zahlen: wie positive Zahlen, das heit:
                                'AUFrundung immer von der Null weg! ABrundung zur Null hin!
                                'Negative Zahl erst positiv machen, dann runden und dann Minuszeichen davor.
                                If (rstTermine!km_Anzahl * ReKmEinzPreis) < 0 Then
                                    ReKmNettoNeu = CCur(Format(((rstTermine!km_Anzahl * ReKmEinzPreis) * (-1)), "#0.00")) * (-1)
                                Else
                                    ReKmNettoNeu = CCur(Format((rstTermine!km_Anzahl * ReKmEinzPreis), "#0.00"))
                                End If
                                ReKmNetto = ReKmNettoNeu - ReKmNettoBisher
                                
                                'Die Schliessung der Tabelle erfolgt am Ende des Rechnungslaufs
                                '   rstKmPreise.Close
                            End If
                        End If
                    End If
                    
                    
                    'wenn Netto der Rechnungsposition <> 0 oder Netto der KM-Berechnung <> 0
                    If ReTerminNetto <> 0 Or ReKmNetto <> 0 Then
                        'Rechnungsdetails schreiben
                        rstRechnungsdetails.AddNew
                        rstRechnungsdetails!lfd_Nr_Re = rstRechnungen!lfd_Nr
                        rstRechnungsdetails!Termin_ID = rstTermine!Termin_ID
                        rstRechnungsdetails!lfd_Nr_Termin = rstTermine!lfd_Nr
                        rstRechnungsdetails!Privat = rstTermine!Privat
                        rstRechnungsdetails!Start = ReDetailsTerminStart
                        rstRechnungsdetails!Ende = ReDetailsTerminEnde
                        rstRechnungsdetails!Dauer = ReDetailsTerminDauer
                            'alt: rstRechnungsdetails!Start = rstTermine!Start
                            'alt: rstRechnungsdetails!Ende = rstTermine!Ende
                            'alt: rstRechnungsdetails!Dauer = rstTermine!Dauer
                        rstRechnungsdetails!Betreff = rstTermine!Betreff
                        rstRechnungsdetails!geloescht = rstTermine!geloescht
                        rstRechnungsdetails!MMJJJJ_fuer_Re = "01." & Format(ReMonat, "00") & "." & ReJahr
                        rstRechnungsdetails!Dauer_fuer_Re = ReDauerBerechnet
                        rstRechnungsdetails!Std_Satz = ReStdSatzNetto
                        rstRechnungsdetails!Netto_bisher = ReNettoBisher
                        rstRechnungsdetails!Netto = ReTerminNetto
                        '---> Aktuellen MwSt_Satz eintragen
                        '---> MwSt_Kz zunchst auf "1" setzen
                        rstRechnungsdetails!MwSt_Satz = ReMwStSatz
                        rstRechnungsdetails!MwSt_Kz = 1                 ' zunchst alle Rechnungspositionen mit "1" versehen
                        'Entsprechend den Optionen zur km-Verarbeitung die Daten der Rechnungszeile fllen
                        '(Re-Zeile nur dann fllen, wenn wirklick km erfasst wurden, oder bei Rckrechnung
                        ' Berechnungsergebnisse vorliegen!)
                        '(Re-Zeile nur dann fllen, wenn Terminbeginn im aktuellen ReMonat!)
                        If (km_Erfassung = True) And (ReKmRechnungszeile = False) _
                         And ((rstTermine!km_Anzahl <> 0) Or (ReKmNetto <> 0) Or (ReKmNettoBisher <> 0)) _
                         And rstTermine!S_Jahr = ReJahr And rstTermine!S_Monat = ReMonat Then
                            If km_Verwendungen = 1 Then                     'nur km-Nachweis, ohne Berechnung
                                rstRechnungsdetails!km_Netto_bisher = 0
                                rstRechnungsdetails!km_Netto = 0
                                rstRechnungsdetails!km_Anzahl = rstTermine!km_Anzahl
                                rstRechnungsdetails!km_Preis = 0
                                rstRechnungsdetails!km_Text = km_RechText
                                rstRechnungsdetails!km_Einheit = km_TabellenKuerzel
                                ReKmRechnungszeile = True
                            End If
                            If km_Verwendungen = 2 Then                     'km-Nachweis und Berechnung
                                rstRechnungsdetails!km_Netto_bisher = ReKmNettoBisher
                                rstRechnungsdetails!km_Netto = ReKmNetto
                                rstRechnungsdetails!km_Anzahl = rstTermine!km_Anzahl
                                rstRechnungsdetails!km_Preis = ReKmEinzPreis
                                rstRechnungsdetails!km_Text = km_RechText
                                rstRechnungsdetails!km_Einheit = km_TabellenKuerzel
                                ReKmRechnungszeile = True
                            End If
                        Else
                            'wenn km-Rechnungszeile bereits erstellt wurde oder nicht erstellt werden soll
                            rstRechnungsdetails!km_Netto_bisher = 0
                            rstRechnungsdetails!km_Netto = 0
                            rstRechnungsdetails!km_Anzahl = 0
                            rstRechnungsdetails!km_Preis = 0
                            rstRechnungsdetails!km_Text = " "
                            rstRechnungsdetails!km_Einheit = " "
                        End If
                        rstRechnungsdetails.Update
                        'Da Termin nun auf der Rechnung steht, auch den Marker setzen, damit spter die Daten
                        'in die Termintabelle bernommen werden
                        TerminIstBerechnet = True
                        RePositionen = RePositionen + 1
                        ReGesamtNetto = ReGesamtNetto + ReTerminNetto + ReKmNetto
                        'ReKmNetto hier schon lschen, da es sonst unten nochmal zum Rechnungs-
                        'gesamtbetrag addiert wird
                        ReKmNetto = 0
                        '...und Werte mit akt. Tag fllen
                        ReDauerBerechnet = NettoMatrix(MatrixTag, 2)
                        ReStdSatzNetto = NettoMatrix(MatrixTag, 1)
                        ReTerminNetto = NettoMatrix(MatrixTag, 3)
                        ReNettoBisher = 0
                        ReKmNettoBisher = 0
                        'tatschlich berechnete von-/bis-Monate zur Rechnung vermerken
                        Re_von_bis_vermerken
                    End If      'Netto der Rechnungsposition <> 0?
                    
                    
                    
                    'falls Termin-ENDE wegen Gebhrenwechsel im Terminzeitraum angepasst,
                    '   nun den Termin-ANFANG um eine Sekunde weiter stellen!
                    '   (= 00:00 des nchsten Tages)
                    If ReDetailsTerminAngepasst = True Then
                        ReDetailsTerminStart = ReDetailsTerminEnde + 0.000012
                        ReDetailsTerminAngepasst = False
                    End If
                    
                    
                    
                End If  'Std-Satz des Vortages gleich akt. Tag
            End If      'Terminbeginn?
        End If          'MatrixTag=1?
    Next MatrixTag
    'letzte, noch nicht gespeicherte Werte als Re-Datensatz speichern
            'bisher berechnetes bercksichtigen (hier nur beim ersten Re-Datensatz)
            
            'Achtung: An dieser Stelle "ReKmNettoBisher" NICHT abziehen, da "ReTerminNetto" nur fr
            '   den eigentlichen Termin (Zeitdauer) vorgesehen ist, nicht fr den Km-Anteil!
            ReTerminNetto = ReTerminNetto - ReNettoBisher
            
            
            If ReTerminMonatssplitting = True Then
                'wenn Monatsende erreicht und Termin darber hinaus geht: ENDE(!) fr Rechnungsdetails anpassen
                '   START(!) nach dem Schreiben der Rechnungsdetails anpassen
                If (rstTermine!E_Jahr > ReJahr) Or ((rstTermine!E_Jahr = ReJahr) And (rstTermine!E_Monat > ReMonat)) _
                    Or ((rstTermine!E_Jahr = ReJahr) And (rstTermine!E_Monat = ReMonat) And (rstTermine!E_Tag > (MatrixTag))) Then
                    'letzter Matrixtag ist ungleich Termin-ENDE:
                    '   Termin-Ende fr Rechnungsdetails auf 23:59 des letzten Matrixtages plus 1 Sekunde einstellen und
                    '   Termin-Dauer mit aktueller (berechneter) Dauer fllen
                    ReDetailsTerminEnde = Format((MatrixTag - 1), "00") & "." & Format(ReMonat, "00") & "." & ReJahr & " 23:59:59"
                    ReDetailsTerminEnde = ReDetailsTerminEnde + 0.000012
                    ReDetailsTerminDauer = ReDauerBerechnet
                    ReDetailsTerminAngepasst = True
                End If      'Prfung von Termin-Ende
                'wenn Monat = 1 und START des Termines davor liegt, dann 1.1. als Start fr Rechnungsdetails
                If (ReMonat = 1) And (rstTermine!S_Jahr < ReJahr) Then
                    ReDetailsTerminStart = "01.01." & ReJahr
                End If
                'wenn der Terminbeginn VOR dem ersten Monat des RechnunsZEITRAUMES liegt, und der aktuelle Monat
                'der erste Monat des Rechnungszeitraumes ist, und der Terminbeginn noch nicht angepasst wurde
                '(d.h. ReDetailsTerminStart noch kleiner als 00:00 des 1. des akt. Rechnungsmonats ist!),
                'dann den 1. des aktuellen Monats mit 00:00 als Terminbeginn auf der Re-Zeile eintragen
                If (ReMonat = ReMonatVon) And (CDate(ReDetailsTerminStart) < CDate("01" & "." & Format(ReMonat, "00") & "." & ReJahr & " 00:00:00")) Then
                    ReDetailsTerminStart = CDate("01" & "." & Format(ReMonat, "00") & "." & ReJahr & " 00:00:00")
                End If
                
            
                'Matrixende ist erreicht,...
                '...wenn Termine-ENDE im aktuellen Monat liegt,...
                '...und Termin-ANFANG und -ENDE nicht am selben Kalendertag liegen:
                '   Termin-Ende fr Rechnungsdetails auf echtes Terminende einstellen und
                '   Termin-Dauer mit aktueller (berechneter) Dauer fllen
                If (rstTermine!E_Jahr = ReJahr) And (rstTermine!E_Monat = ReMonat) Then
                    ReDetailsTerminEnde = rstTermine!Ende
                    ReDetailsTerminDauer = ReDauerBerechnet
                        '   folgende Zeile deaktivert, da es bei Matrixende und Terminende im Monat
                        '   keinen Folgeeintrag gibt und der Termin-Startwert nicht angepasst werden braucht
                        'ReDetailsTerminAngepasst = True
                End If
            End If      'von ReTerminMonatssplitting
            
            
            'Die km-Berechnung erfolgt immer auf den Terminbeginn!
            'Wenn der Terminbeginn im aktuellen Berechnungsmonat liegt, die km-Rechnungszeile noch
            '   nicht erstellt wurde, und die km-Abrechnungsparameter eine BERECHNUNG vorsehen,
            '   dann aktuellen km-Betrag ermitteln und bisher berechnetes km-Netto verrechnen.
            If ReKmRechnungszeile = False Then
                If km_Erfassung = True And km_Verwendungen = 2 Then
                    If rstTermine!S_Jahr = ReJahr And rstTermine!S_Monat = ReMonat Then
                        'Die ffnung der Tabelle erfolgte bereits zu Beginn des Rechnungslaufs
                        '   FilterKmPreis = "SELECT * FROM Km_Preise ORDER BY gilt_ab DESC;"
                        '   Set rstKmPreise = dbs.OpenRecordset(FilterKmPreis)
                        '   If rstKmPreise.RecordCount <> 0 Then
                        '       'Recordset auffllen
                        '       rstKmPreise.MoveLast
                        '       rstKmPreise.MoveFirst
                        '   End If
                        
                        'Ermittlung des gltigen Preises am Tag des Terminbeginns
                        If rstKmPreise.RecordCount = 0 Then
                            'wenn die Preistabelle leer ist
                            ReKmEinzPreis = 0
                        Else
                            'wenn Preise vorhanden sind
                            rstKmPreise.MoveFirst
                            FilterKmPreis = "[gilt_ab] <= #" & Format(rstTermine!Start, "mm") & "/" & Format(rstTermine!Start, "Dd") & "/" & Format(rstTermine!Start, "yy") & "#"
                            rstKmPreise.FindFirst FilterKmPreis
                            If rstKmPreise.NoMatch Then
                                'zu diesem Terminbeginn existierte noch kein Preis
                                ReKmEinzPreis = 0
                            Else
                                ReKmEinzPreis = rstKmPreise!Preis
                            End If
                        End If
                        'km * Preis - bereitsBerechnetes
                        'Mit CCur(Format(.. wird der ermittelte Wert auf 2 Nachkommastellen gerundet!
                        'ACHTUNG:
                        'Rundung negativer Zahlen: wie positive Zahlen, das heit:
                        'AUFrundung immer von der Null weg! ABrundung zur Null hin!
                        'Negative Zahl erst positiv machen, dann runden und dann Minuszeichen davor.
                        If (rstTermine!km_Anzahl * ReKmEinzPreis) < 0 Then
                            ReKmNettoNeu = CCur(Format(((rstTermine!km_Anzahl * ReKmEinzPreis) * (-1)), "#0.00")) * (-1)
                        Else
                            ReKmNettoNeu = CCur(Format((rstTermine!km_Anzahl * ReKmEinzPreis), "#0.00"))
                        End If
                        ReKmNetto = ReKmNettoNeu - ReKmNettoBisher
                        
                        'Die Schliessung der Tabelle erfolgt am Ende des Rechnungslaufs
                        '   rstKmPreise.Close
                    End If
                End If
            End If
            
            
            'wenn Netto der Rechnungsposition <> 0 oder Netto der KM-Berechnung <> 0
            If ReTerminNetto <> 0 Or ReKmNetto <> 0 Then
                'Rechnungsdetails schreiben
                rstRechnungsdetails.AddNew
                rstRechnungsdetails!lfd_Nr_Re = rstRechnungen!lfd_Nr
                rstRechnungsdetails!Termin_ID = rstTermine!Termin_ID
                rstRechnungsdetails!lfd_Nr_Termin = rstTermine!lfd_Nr
                rstRechnungsdetails!Privat = rstTermine!Privat
                rstRechnungsdetails!Start = ReDetailsTerminStart
                rstRechnungsdetails!Ende = ReDetailsTerminEnde
                rstRechnungsdetails!Dauer = ReDetailsTerminDauer
                    'alt: rstRechnungsdetails!Start = rstTermine!Start
                    'alt: rstRechnungsdetails!Ende = rstTermine!Ende
                    'alt: rstRechnungsdetails!Dauer = rstTermine!Dauer
                rstRechnungsdetails!Betreff = rstTermine!Betreff
                rstRechnungsdetails!geloescht = rstTermine!geloescht
                rstRechnungsdetails!MMJJJJ_fuer_Re = "01." & Format(ReMonat, "00") & "." & ReJahr
                rstRechnungsdetails!Dauer_fuer_Re = ReDauerBerechnet
                rstRechnungsdetails!Std_Satz = ReStdSatzNetto
                rstRechnungsdetails!Netto_bisher = ReNettoBisher
                rstRechnungsdetails!Netto = ReTerminNetto
                '---> Aktuellen MwSt_Satz eintragen
                '---> MwSt_Kz zunchst auf "1" setzen
                rstRechnungsdetails!MwSt_Satz = ReMwStSatz
                rstRechnungsdetails!MwSt_Kz = 1                 ' zunchst alle Rechnungspositionen mit "1" versehen
                'Entsprechend den Optionen zur km-Verarbeitung die Daten der Rechnungszeile fllen
                '(Re-Zeile nur dann fllen, wenn wirklich km erfasst wurden, oder bei Rckrechnung
                ' Berechnungsergebnisse vorliegen!)
                '(Re-Zeile nur dann fllen, wenn Terminbeginn im aktuellen ReMonat!)
                If (km_Erfassung = True) And (ReKmRechnungszeile = False) _
                 And ((rstTermine!km_Anzahl <> 0) Or (ReKmNetto <> 0) Or (ReKmNettoBisher <> 0)) _
                 And rstTermine!S_Jahr = ReJahr And rstTermine!S_Monat = ReMonat Then
                    If km_Verwendungen = 1 Then                     'nur km-Nachweis, ohne Berechnung
                        rstRechnungsdetails!km_Netto_bisher = 0
                        rstRechnungsdetails!km_Netto = 0
                        rstRechnungsdetails!km_Anzahl = rstTermine!km_Anzahl
                        rstRechnungsdetails!km_Preis = 0
                        rstRechnungsdetails!km_Text = km_RechText
                        rstRechnungsdetails!km_Einheit = km_TabellenKuerzel
                        ReKmRechnungszeile = True
                    End If
                    If km_Verwendungen = 2 Then                     'km-Nachweis und Berechnung
                        rstRechnungsdetails!km_Netto_bisher = ReKmNettoBisher
                        rstRechnungsdetails!km_Netto = ReKmNetto
                        rstRechnungsdetails!km_Anzahl = rstTermine!km_Anzahl
                        rstRechnungsdetails!km_Preis = ReKmEinzPreis
                        rstRechnungsdetails!km_Text = km_RechText
                        rstRechnungsdetails!km_Einheit = km_TabellenKuerzel
                        ReKmRechnungszeile = True
                    End If
                Else
                    'wenn km-Rechnungszeile bereits erstellt wurde oder nicht erstellt werden soll
                    rstRechnungsdetails!km_Netto_bisher = 0
                    rstRechnungsdetails!km_Netto = 0
                    rstRechnungsdetails!km_Anzahl = 0
                    rstRechnungsdetails!km_Preis = 0
                    rstRechnungsdetails!km_Text = " "
                    rstRechnungsdetails!km_Einheit = " "
                End If
                rstRechnungsdetails.Update
                'Da Termin nun auf der Rechnung steht, auch den Marker setzen, damit spter die Daten
                'in die Termintabelle bernommen werden
                TerminIstBerechnet = True
                RePositionen = RePositionen + 1
                ReGesamtNetto = ReGesamtNetto + ReTerminNetto + ReKmNetto
                'tatschlich berechnete von-/bis-Monate zur Rechnung vermerken
                Re_von_bis_vermerken
            End If      'Netto der Rechnungsposition <> 0?
            
            
            'falls Termin-ENDE angepasst, weil Terminende nach akt. Monat liegt:
            '   nun den Termin-ANFANG um eine Sekunde weiter stellen!
            '   (= 00:00 des nchsten Tages)
            If ReDetailsTerminAngepasst = True Then
                ReDetailsTerminStart = ReDetailsTerminEnde + 0.000012
                ReDetailsTerminAngepasst = False
            End If
            
            
            'Werte auf 0 (Null) setzen
            ReDauerBerechnet = 0
            ReStdSatzNetto = 0
            ReNettoBisher = 0
            ReTerminNetto = 0
            ReKmNetto = 0
            'folgende Zeile deaktiviert, da der Wert unten noch bentigt wird
            'ReKmNettoNeu = 0
            ReKmNettoBisher = 0
            ReKmEinzPreis = 0
    'Abrechnungsdaten des Monats summieren
    ReTerminNetto = 0
    For MatrixTag = 1 To 31 Step 1
        ReTerminNetto = ReTerminNetto + NettoMatrix(MatrixTag, 3)
    Next MatrixTag
    'wenn kein Testlauf, bisherige Abrechnungsdaten aktualisieren,
    'aber nur, wenn fr den Termin auch eine Abrechnungszeile auf der Rechnung erstellt wurde
    If (ReTestlauf = False) Then
        If (TerminIstBerechnet = True) Then
            If (rstAbgerechnet.RecordCount <> 0) Then
                'vorhandene Abrechnungsdaten aktualisieren
                rstAbgerechnet.Edit
                rstAbgerechnet!Netto = ReTerminNetto
                rstAbgerechnet!km_Netto = ReKmNettoNeu
                rstAbgerechnet.Update
            Else
                'Abrechnungsdaten zum ersten mal erfassen
                rstAbgerechnet.AddNew
                rstAbgerechnet!lfd_Nr_Termin = rstTermine!lfd_Nr
                rstAbgerechnet!Jahr = ReJahr
                rstAbgerechnet!Monat = ReMonat
                rstAbgerechnet!Netto = ReTerminNetto
                rstAbgerechnet!km_Netto = ReKmNettoNeu
                rstAbgerechnet.Update
            End If
            'Wert nun lschen
            ReKmNettoNeu = 0
        End If
    Else
        'wenn Kalkulation: die berechneten Werte als Kalkulation speichern
        If ReLaufArt = 5 Then
            If (rstKalkuliert.RecordCount <> 0) Then
                'vorhandene Abrechnungsdaten aktualisieren
                rstKalkuliert.Edit
                rstKalkuliert!Netto = ReTerminNetto
                rstKalkuliert!km_Netto = ReKmNettoNeu
                rstKalkuliert.Update
            Else
                'Abrechnungsdaten zum ersten mal erfassen
                rstKalkuliert.AddNew
                rstKalkuliert!lfd_Nr_Termin = rstTermine!lfd_Nr
                rstKalkuliert!Jahr = ReJahr
                rstKalkuliert!Monat = ReMonat
                rstKalkuliert!Netto = ReTerminNetto
                rstKalkuliert!km_Netto = ReKmNettoNeu
                rstKalkuliert.Update
            End If
        End If
        
    End If          'Testlauf?

End Sub

Public Sub MatrixNettoFuellen()
                
    'Matrix mit Netto/Tag fllen -----------------------------------------------------------
    For MatrixTag = 1 To 31 Step 1
        'Netto = Tagesminuten * (Stundensatz / 60)
        '   Hinweis: mit CCur(Format(..)) wird der Nettobetrag auf 2 Nachkommastellen gerundet,
        '   um "merkwrdige" Nettosummen auf der Rechnung zu verhindern, die durch Addition der
        '   nicht sichtbaren 3. und 4. Nachkommastellen entstehen wrden.
        'ACHTUNG:
        'Rundung negativer Zahlen: wie positive Zahlen, das heit:
        'AUFrundung immer von der Null weg! ABrundung zur Null hin!
        'Negative Zahl erst positiv machen, dann runden und dann Minuszeichen davor.
        If (NettoMatrix(MatrixTag, 2) * (NettoMatrix(MatrixTag, 1) / 60)) < 0 Then
            NettoMatrix(MatrixTag, 3) = CCur(Format(((NettoMatrix(MatrixTag, 2) * (NettoMatrix(MatrixTag, 1) / 60)) * (-1)), "#0.00")) * (-1)
        Else
            NettoMatrix(MatrixTag, 3) = CCur(Format((NettoMatrix(MatrixTag, 2) * (NettoMatrix(MatrixTag, 1) / 60)), "#0.00"))
        End If
    Next MatrixTag

End Sub

Public Sub MatrixMinutenFuellen()
                
    'Matrix mit Minuten/Tag des Termines fllen --------------------------------------------
    'letzten Tag ermitteln...
    MatrixTag = 31
    If (rstTermine!E_Jahr > ReJahr) Or ((rstTermine!E_Jahr = ReJahr) And (rstTermine!E_Monat > ReMonat)) Then
        'letzten Tag des Monats ermitteln und Matrix darauf einstellen
        If ReMonat = 12 Then
            MatrixDatum = "01.01." & (ReJahr + 1)
        Else
            MatrixDatum = "01." & Format(ReMonat + 1, "00") & "." & ReJahr
        End If
        MatrixTag = Day(MatrixDatum - 1)
    Else
        'Terminende liegt im akt. Monat
        MatrixTag = rstTermine!E_Tag
    End If
    'und Matrix von hinten beginnend mit Tagesminuten fllen...
    For MatrixTag = MatrixTag To 1 Step -1
        If ((rstTermine!E_Jahr = ReJahr) And (rstTermine!E_Monat = ReMonat) And (MatrixTag = rstTermine!E_Tag)) Then
            'wir haben das Terminende vor uns
            If ((rstTermine!S_Jahr = ReJahr) And (rstTermine!S_Monat = ReMonat) And (MatrixTag = rstTermine!S_Tag)) Then
                'Terminende und Terminbeginn fallen auf den selben Tag
                NettoMatrix(MatrixTag, 2) = ((Hour(rstTermine!Ende) * 60) + Minute(rstTermine!Ende)) - ((Hour(rstTermine!Start) * 60) + Minute(rstTermine!Start))
                'Schleife verlassen, da Matrix vor Terminbeginn nicht gefllt werden braucht/darf
                Exit For
            Else
                'dieser Tag ist nur das Terminende
                NettoMatrix(MatrixTag, 2) = (Hour(rstTermine!Ende) * 60) + Minute(rstTermine!Ende)
            End If
        Else
            If ((rstTermine!S_Jahr = ReJahr) And (rstTermine!S_Monat = ReMonat) And (MatrixTag = rstTermine!S_Tag)) Then
                'wir haben den Terminbeginn vor uns
                NettoMatrix(MatrixTag, 2) = 1440 - (Hour(rstTermine!Start) * 60) - Minute(rstTermine!Start)
                'Schleife verlassen, da Matrix vor Terminbeginn nicht gefllt werden braucht/darf
                Exit For
            Else
                'wir haben einen Tag zwischen Terminbeginn und -ende vor uns
                '1 ganzer Tag = 1440 Minuten
                NettoMatrix(MatrixTag, 2) = 1440
            End If      'Prfung auf Terminbeginn
        End If          'Prfung auf Terminende
    Next MatrixTag

End Sub

Public Sub MatrixGebuehrenFuellen()

    'Matrix intitialisieren und mit Gebhren fllen ----------------------------------------
    If (ReKunde = ReKundeZuletzt) And (ReMonat = ReMonatZuletzt) And (ReAktTerminKategorie = ReKategorieZuletzt) And (ReAktTerminKalender = ReKalenderZuletzt) Then
        'Kunde, Kategorie, Kalender und Monat mit vorherigem Durchlauf identisch
        For MatrixTag = 1 To 31 Step 1
            NettoMatrix(MatrixTag, 1) = NettoMatrixKopie(MatrixTag, 1)  'Gebhr
            NettoMatrix(MatrixTag, 2) = 0                               'Minuten/Tag
            NettoMatrix(MatrixTag, 3) = 0                               'Netto/Tag
        Next MatrixTag
    Else
        'Kunde, Kategorie, Kalender oder Monat mit vorherigem Durchlauf verschieden, Matrixgebhren neu fllen
        For MatrixTag = 1 To 31 Step 1
            NettoMatrix(MatrixTag, 1) = 0       'Gebhr
            NettoMatrix(MatrixTag, 2) = 0       'Minuten/Tag
            NettoMatrix(MatrixTag, 3) = 0       'Netto/Tag
        Next MatrixTag
        ' 4) Gebhrentabelle, vorbereiten und ffnen
        FilterGebuehr = "SELECT * FROM Preise WHERE "
        'evtl. auf einen kundenspezifischen Preis einstellen
        If (ReGebuehrAllgemein = True) Then
            FilterGebuehr = FilterGebuehr & "([lfd_Nr_Kunde]=" & SatzKontaktDummy & ")"
        Else
            FilterGebuehr = FilterGebuehr & "([lfd_Nr_Kunde]=" & ReKunde & ")"
        End If
        
    'Solange Kategorie und Kalender beim kundenspezifischen Preis nicht hinterlegt werden knnen,
    'erfolgt die Eingrenzung nach Kategorie und Kalender nur, wenn KEIN kundenspezifischer Preis berechnet
    'werden soll
    If ReGebuehrAllgemein = True Then
    
        'auf die Kategorie des abzurechnenden Termins einstellen
        If (RePreisJeKategorie = True) Or (ReKundePreisJeKategorie = True) Then
            'Achtung Spezialfall!
            'Bei Preisen nach Terminkategorie die Dummy-Kategorie (also "(ohne Kategorie)") als ungltige
            'Kategorie ausklammern, da diese fr die allgemeinen Preise verwendet wird:
            FilterGebuehr = FilterGebuehr & " AND ([lfd_Nr_Kategorie]=" & ReAktTerminKategorie & ")" & _
                " AND ([lfd_Nr_Kategorie]<>" & SatzKategorieDummy & ")"
        Else
            'Nur wenn in den Einstellungen die Preise ALLGEMEIN (NICHT nach Kategorie) berechnet werden sollen,
            'ist explizit die Preislist der Dummy-Kategorie auszuwhlen, anderenfalls Kategorie auf 0 setzen!
            If (RePreisJeKategorie = False) Then
                FilterGebuehr = FilterGebuehr & " AND ([lfd_Nr_Kategorie]=" & SatzKategorieDummy & ")"
            Else
                FilterGebuehr = FilterGebuehr & " AND ([lfd_Nr_Kategorie]=0)"
            End If
        End If
        'auf den Kalender des abzurechnenden Termins einstellen
        If (RePreisJeKalender = True) Or (ReKundePreisJeKalender = True) Then
            FilterGebuehr = FilterGebuehr & " AND ([lfd_Nr_Kalender]=" & ReAktTerminKalender & ")"
        Else
            FilterGebuehr = FilterGebuehr & " AND ([lfd_Nr_Kalender]=0)"
        End If
        
    End If
        
        
        'Liste nach Datum aufsteigend sortieren
        FilterGebuehr = FilterGebuehr & " ORDER BY [gilt_ab]"
        
        Set rstGebuehr = dbs.OpenRecordset(FilterGebuehr)
        If (rstGebuehr.RecordCount <> 0) Then rstGebuehr.MoveLast
        If (rstGebuehr.RecordCount > 0) Then
            MatrixTag = 31
            'vorhandene Gebhren in Matrix eintragen
            Do While Not rstGebuehr.BOF
                Select Case rstGebuehr!Jahr
                Case Is > ReJahr
                    '...nichts zu tun
                Case Is < ReJahr
                    'Rest/komplette Matrix mit Gebhr fllen
                    'und Gebhrendurchlauf verlassen
                    For MatrixTag = MatrixTag To 1 Step -1
                        NettoMatrix(MatrixTag, 1) = rstGebuehr!Std_Satz
                    Next MatrixTag
                    Exit Do
                Case Is = ReJahr
                    Select Case rstGebuehr!Monat
                    Case Is > ReMonat
                        '...nichts zu tun
                    Case Is < ReMonat
                        'Rest der Matrix mit Gebhr fllen
                        'und Gebhrendurchlauf verlassen
                        For MatrixTag = MatrixTag To 1 Step -1
                            NettoMatrix(MatrixTag, 1) = rstGebuehr!Std_Satz
                        Next MatrixTag
                        Exit Do
                    Case Is = ReMonat
                        'entspr. Tage der Matrix mit Gebhr fllen
                        For MatrixTag = MatrixTag To rstGebuehr!Tag Step -1
                            NettoMatrix(MatrixTag, 1) = rstGebuehr!Std_Satz
                        Next MatrixTag
                    End Select
                End Select
                'Matrix komplett gefllt, Schleife vorzeitig verlassen
                If MatrixTag = 0 Then Exit Do
                'sonst weiter
                rstGebuehr.MovePrevious
            Loop
        End If
        rstGebuehr.Close
        'mit Gebhren gefllte Matrix kopieren
        NettoMatrixKopie = NettoMatrix
    End If

End Sub

Public Sub RechnungsnummerGenerieren()
    'wenn Testlauf, nur schematische Nr. und Sub verlassen
    If (ReTestlauf = True) Then
        ReNummer = ReNummerSchema & "   (TESTLAUF)"
        Exit Sub
    End If
    'Schema laden
    ReNummer = ReNummerSchema
    'Jahr zumischen
    Do While (InStr(1, ReNummer, "[J]") >= 1)
        ReNummer = Left(ReNummer, InStr(1, ReNummer, "[J]") - 1) & Right(ReJahr, 1) & Mid(ReNummer, InStr(1, ReNummer, "[J]") + 3)
    Loop
    Do While (InStr(1, ReNummer, "[JJ]") >= 1)
        ReNummer = Left(ReNummer, InStr(1, ReNummer, "[JJ]") - 1) & Right(ReJahr, 2) & Mid(ReNummer, InStr(1, ReNummer, "[JJ]") + 4)
    Loop
    Do While (InStr(1, ReNummer, "[JJJJ]") >= 1)
        ReNummer = Left(ReNummer, InStr(1, ReNummer, "[JJJJ]") - 1) & ReJahr & Mid(ReNummer, InStr(1, ReNummer, "[JJJJ]") + 6)
    Loop
    'fortlaufende Nr. zumischen
    ReLfdNrBeginn = 0
    ReLfdNrLaenge = 1
    ReLfdNrBeginn = InStr(1, ReNummer, "#")
    'bisherige lfd. ReNr merken, falls die Rechnung 0,- Betrag ergibt und gelscht werden muss,
    'fr die Rsetzung der laufenden ReNr ("-1" bedeutet, dass die Rechnungsnummer keine lfd. Nr. enthlt!)
    ReNr_Alt = -1
    If (ReLfdNrBeginn > 0) Then
        'Soll-Lnge der laufenden Nr. ermitteln
        Do While (StrComp(Mid(ReNummer, (ReLfdNrBeginn + ReLfdNrLaenge), 1), "#") = 0)
            ReLfdNrLaenge = ReLfdNrLaenge + 1
        Loop
        'nchste laufende Nr. berechnen
        FilterReNummer = "SELECT * FROM Rechnungsnummern WHERE ([Jahr]=" & ReJahr & ")"
        Set rstRechnungsnummern = dbs.OpenRecordset(FilterReNummer)
        If (rstRechnungsnummern.RecordCount = 0) Then
            ReNr_Alt = 0
            ReLfdNr = 1
            rstRechnungsnummern.AddNew
            rstRechnungsnummern!Jahr = ReJahr
            rstRechnungsnummern!ReNr = ReLfdNr
            rstRechnungsnummern.Update
        Else
            ReNr_Alt = rstRechnungsnummern!ReNr
            ReLfdNr = rstRechnungsnummern!ReNr + 1
            rstRechnungsnummern.Edit
            rstRechnungsnummern!ReNr = ReLfdNr
            rstRechnungsnummern.Update
        End If
        rstRechnungsnummern.Close
        'Rechnungsnummer komplettieren
        ReNummer = Left(ReNummer, ReLfdNrBeginn - 1) & _
            Right(Format(ReLfdNr, "00000000000000000000000000000000000000000000000000"), ReLfdNrLaenge) & _
            Mid(ReNummer, ReLfdNrBeginn + ReLfdNrLaenge)
    End If
    
End Sub

Public Sub MwSt_SplittingTest()
    Dim NeuNetto As Currency
    Dim NeuSteuer As Currency
    Dim NeuBrutto As Currency
    
    Dim rst2 As Recordset
    
    '--------------------------------------------------------------------------------------------------------
    '   Hier wird geprft, ob in der letzten Rechnung in den Positionen mehr als 1 MwSt-Satz vorhanden ist.
    '   Wenn ja, wird die MwSt-Splitting-Tabelle geschrieben, in der Rechnung das Splitting-Kennzeichen
    '   gesetzt und in die betroffenen Rechnungspositionen das Kennzeichen fr die jeweilige MwSt geschrieben.
    
    MwStSplittingTestTextGesamt = MwStSplittingTestTextVor & rstRechnungen!lfd_Nr & MwStSplittingTestTextNach
    Set rstMwStSplittingTest = dbs.OpenRecordset(MwStSplittingTestTextGesamt)
    If rstMwStSplittingTest.RecordCount > 1 Then
        '1.) MwSt-Splitting-Eintrag zur Rechnung bilden
        MwSt_Kz_Zaehler = 1
        rstMwStSplittingTest.MoveLast               'auffllen
        rstMwStSplittingTest.MoveFirst
        Do While Not rstMwStSplittingTest.EOF
            rstMwStSplitting.AddNew
            rstMwStSplitting!lfd_Nr_Re = rstRechnungen!lfd_Nr
            rstMwStSplitting!Kz = Format(MwSt_Kz_Zaehler, "##0")
            rstMwStSplitting!Netto = rstMwStSplittingTest!SumNetto + rstMwStSplittingTest!SumKmNetto
            rstMwStSplitting!Prozent = rstMwStSplittingTest!MwSt_Satz
            'ACHTUNG:
            'Rundung negativer Zahlen: wie positive Zahlen, das heit:
            'AUFrundung immer von der Null weg! ABrundung zur Null hin!
            'Negative Zahl erst positiv machen, dann runden und dann Minuszeichen davor.
            If ((rstMwStSplitting!Netto * rstMwStSplitting!Prozent) / 100) < 0 Then
                rstMwStSplitting!Steuer = CCur(Format((((rstMwStSplitting!Netto * rstMwStSplitting!Prozent) / 100) * (-1)), "#0.00")) * (-1)
            Else
                rstMwStSplitting!Steuer = CCur(Format(((rstMwStSplitting!Netto * rstMwStSplitting!Prozent) / 100), "#0.00"))
            End If
            rstMwStSplitting!Brutto = rstMwStSplitting!Netto + rstMwStSplitting!Steuer
            rstMwStSplitting.Update
            'nchster Datensatz
            rstMwStSplittingTest.MoveNext
            MwSt_Kz_Zaehler = MwSt_Kz_Zaehler + 1
        Loop
        
        '2.) MwSt-Kuerzel der Rechnungspositionen korrigieren
        '    dazu die erstellte Splittingtabelle benutzen
        NeuNetto = 0
        NeuSteuer = 0
        NeuBrutto = 0
        MwStSplittingTestTextGesamt = "[lfd_Nr_Re]=" & rstRechnungen!lfd_Nr
        rstMwStSplitting.MoveFirst
        rstMwStSplitting.FindFirst MwStSplittingTestTextGesamt
        Do While Not rstMwStSplitting.NoMatch
            NeuNetto = NeuNetto + rstMwStSplitting!Netto
            NeuSteuer = NeuSteuer + rstMwStSplitting!Steuer
            NeuBrutto = NeuBrutto + rstMwStSplitting!Brutto
            'da bei Rechnungsgenerierung alle Rechnungspositionen vorab das Kz = 1 erhalten,
            'brauchen nur die Kz ab 2 korrigiert zu werden
            If CInt(Val(rstMwStSplitting!Kz)) > 1 Then
                If ReTestlauf = True Then
                    Set rst2 = dbs.OpenRecordset("SELECT * FROM ReTestlauf_Rechnungsdetails WHERE [lfd_Nr_Re]=" & rstRechnungen!lfd_Nr & " AND [MwSt_Satz]=" & rstMwStSplitting!Prozent)
                Else
                    Set rst2 = dbs.OpenRecordset("SELECT * FROM Rechnungsdetails WHERE [lfd_Nr_Re]=" & rstRechnungen!lfd_Nr & " AND [MwSt_Satz]=" & rstMwStSplitting!Prozent)
                End If
                If rst2.RecordCount > 0 Then
                    rst2.MoveLast               'auffllen
                    rst2.MoveFirst
                    Do While Not rst2.EOF
                        rst2.Edit
                        rst2!MwSt_Kz = rstMwStSplitting!Kz
                        rst2.Update
                        'nchster Datensatz
                        rst2.MoveNext
                    Loop
                End If
                rst2.Close
            End If
            'nchsten MwSt-Eintrag suchen
            rstMwStSplitting.FindNext MwStSplittingTestTextGesamt
        Loop
        
        '3.) Korrektur von Netto, Steuer und Brutto -Gesamtbetrgen der Rechnung
        '    und MwSt-Splitting in der Rechnung vermerken
        rstRechnungen.Edit
        rstRechnungen!MwSt_Satz = 999           ' zustzlich auf einen utopischen Wert setzen
        rstRechnungen!Re_Netto = NeuNetto
        rstRechnungen!Re_MwSt = NeuSteuer
        rstRechnungen!Re_Brutto = NeuBrutto
        rstRechnungen!MwSt_Splitting = True
        rstRechnungen.Update
        'nach dem Speichern, den Datensatzzeiger wieder auf diesen Satz stellen...
        rstRechnungen.Bookmark = rstRechnungen.LastModified
        
    End If
    rstMwStSplittingTest.Close
    
End Sub

Public Sub Rechnungslauf()
    Dim stDocName As String
    Dim stLinkCriteria As String
    
    
    'Datenbankumgebung festlegen
    Set dbs = CurrentDb

    'Variablen initalisieren ====================================================
    'Wenn Kalkulation aus Outlook-bernahme, dann KEINE Formularabfragen
    If KalkulationAusOutlookUebernahme = False Then
        'Aufruf von der Maske Rechnungslaufparameter
        ReDatumBenutzer = Forms!Rechnungslaufparameter.ReDatum.Value
        ReJahr = Forms!Rechnungslaufparameter.Jahresauswahl.Value
        ReMonatVon = Forms!Rechnungslaufparameter.Monat_von.Value
        ReMonatBis = Forms!Rechnungslaufparameter.Monat_bis.Value
        If Forms!Rechnungslaufparameter.Kundenauswahl = 0 Then
            ReKunde = 0
        Else
            ReKunde = Forms!Rechnungslaufparameter.Kunden_direkt.Value
        End If
        If Forms!Rechnungslaufparameter.Kategorieauswahl = 0 Then
            ReKategorie = 0
        Else
            ReKategorie = Forms!Rechnungslaufparameter.Kategorien_direkt.Value
        End If
        ReKopieAnzahl = Forms!Rechnungslaufparameter.Kopieanzahl.Value
        ReKopieZeitpunkt = Forms!Rechnungslaufparameter.Kopie_Zeitpunkt.Value
        'ReJeKategorie = False          ' wird im Parameterformular gesetzt
        ReLaufArt = Forms!Rechnungslaufparameter.Rechnungslauf_Art.Value
        ReTestlauf = Forms!Rechnungslaufparameter.Testlauf_Haken
    Else
        'Aufruf von der Maske Outlookbernahme
        ReDatumBenutzer = Now()
        ReJahr = Year(Forms!Outlook_einlesen.Datum_von.Value)
        ReMonatVon = Month(Forms!Outlook_einlesen.Datum_von.Value)
        ReMonatBis = Month(Forms!Outlook_einlesen.Datum_bis.Value)
        ReKunde = 0                     'alle Kunden
        ReKategorie = 0                 'alle Kategorien
        ReKopieAnzahl = 1
        ReKopieZeitpunkt = 1
        ReJeKategorie = False
        ReLaufArt = 5                   'Kalkulationslauf!
        ReTestlauf = True               'im Testlauf!
        ReEchtlauf = False
    End If
    
    If (ReEchtlauf = True) Then
        ReTestlauf = False
        ReEchtlauf = False
    End If
    
    'Rechnungslauf protokollieren (nur bei Echtlauf!)
    If (ReTestlauf = False) Then
        Set rstRechnungslaeufe = dbs.OpenRecordset("Rechnungslaeufe")
        rstRechnungslaeufe.AddNew
        rstRechnungslaeufe!Start = Now()
        rstRechnungslaeufe!Anwender = Trim(Left(CurrentUser, 100))
        rstRechnungslaeufe!Art = ReLaufArt
        rstRechnungslaeufe!von_Monat = ReMonatVon
        rstRechnungslaeufe!bis_Monat = ReMonatBis
        rstRechnungslaeufe!Jahr = ReJahr
        If ReLaufArt = 4 Then rstRechnungslaeufe!Hinweis = "GRR"        'Marker bei Generalrckrechnung
        If ReKunde = 0 Then
            rstRechnungslaeufe!Kunden = "alle"
        Else
            'Nach Kontaktdetails suchen
            FilterKontakt = "SELECT * FROM Kunden WHERE [lfd_Nr] = " & ReKunde
            Set rstKontakte = dbs.OpenRecordset(FilterKontakt)
                rstRechnungslaeufe!Kunden = rstKontakte!Name1
            rstKontakte.Close
        End If
        If ReKategorie = 0 Then
            rstRechnungslaeufe!Kategorie = "alle"
        Else
            'Nach Kategoriedetails suchen
            FilterKontakt = "SELECT * FROM Kategorien WHERE [lfd_Nr] = " & ReKategorie
            ' "rstKontakte" mal eben nutzen
            Set rstKontakte = dbs.OpenRecordset(FilterKontakt)
                rstRechnungslaeufe!Kategorie = rstKontakte!Name1
            rstKontakte.Close
        End If
        rstRechnungslaeufe.Update
        'zuletzt bearbeiteten Satz wieder zum aktuellen machen
        rstRechnungslaeufe.Bookmark = rstRechnungslaeufe.LastModified
    End If
    
    'nach abrechenbaren Terminen suchen...
    FilterTermin = ""
    'nur Termine, deren Beginn oder Ende im angegeben Zeitraum liegen,
    'oder Beginn und Ende vor und nach dem Zeitraum liegen
    FilterTermin = "SELECT * FROM Termine WHERE (" & _
        "(" & _
            "(([S_Jahr] = " & ReJahr & ") AND ([S_Monat] >= " & ReMonatVon & ") AND ([S_Jahr] = " & ReJahr & ") AND ([S_Monat] <= " & ReMonatBis & "))" & _
            " OR " & _
            "(([E_Jahr] = " & ReJahr & ") AND ([E_Monat] >= " & ReMonatVon & ") AND ([E_Jahr] = " & ReJahr & ") AND ([E_Monat] <= " & ReMonatBis & "))" & _
            " OR " & _
            "(([S_Jahr] < " & ReJahr & ") AND ([E_Jahr] > " & ReJahr & "))" & _
            " OR "
    'Sonderfall ReMonatVon = 1
    If ReMonatVon = 1 Then
        FilterTermin = FilterTermin & _
            "(" & _
                "([S_Jahr] < " & ReJahr & ") AND (([E_Jahr] > " & ReJahr & ") OR (([E_Jahr] = " & ReJahr & ") AND ([E_Monat] > " & ReMonatBis & ")))" & _
            ")"
    Else
        FilterTermin = FilterTermin & _
            "(" & _
                "(([S_Jahr] = " & ReJahr & ") AND ([S_Monat] < " & ReMonatVon & ")) AND (([E_Jahr] > " & ReJahr & ") OR (([E_Jahr] = " & ReJahr & ") AND ([E_Monat] > " & ReMonatBis & ")))" & _
            ")"
    End If
    FilterTermin = FilterTermin & _
        ")"
    'nur Termine, die noch nicht abgerechnet wurden (Ausnahmen: Rechnungslaufart 4 = Generalrueckrechnung, 5 = Kalkulation)
    If (ReLaufArt <> 4) And (ReLaufArt <> 5) Then
        FilterTermin = FilterTermin & " AND (([berechnet] = False) OR ([geaendert_seit_Re] = True))"
    End If
    'Filter evtl. auf einen Kunden einschrenken
    If (ReKunde <> 0) Then
        FilterTermin = FilterTermin & " AND ([lfd_Nr_Kunde] = " & ReKunde & ")"
    End If
    'Filter evtl. auf eine Kategorie einschrenken
    If (ReKategorie <> 0) Then
        FilterTermin = FilterTermin & " AND ([lfd_Nr_Kategorie] = " & ReKategorie & ")"
    End If
    
    'Wenn ReJeKategorie = True, dann zustzlich nach Kategorie sortieren,
    'sonst Termine nach Kunden und Terminbeginn aufsteigend sortieren
    If ReJeKategorie = True Then
        FilterTermin = FilterTermin & ") ORDER BY Termine.lfd_Nr_Kunde, Termine.lfd_Nr_Kategorie, Termine.Start;"
    Else
        FilterTermin = FilterTermin & ") ORDER BY Termine.lfd_Nr_Kunde, Termine.Start;"
    End If
    Set rstTermine = dbs.OpenRecordset(FilterTermin)
    If (rstTermine.RecordCount <> 0) Then rstTermine.MoveLast
    If (rstTermine.RecordCount = 0) Then
        'Meldung und Abbruch, falls keine Termine gefunden
        rstTermine.Close
        Set dbs = Nothing
        'Meldungen nur anzeigen, wenn es kein Kalkulationslauf aus der Outlookbernahme ist
        If KalkulationAusOutlookUebernahme = False Then
            If (ReKunde = 0) Then
                If (ReKategorie = 0) Then
                    MsgBox "Im angegeben Zeitraum wurden keine abrechenbaren Termine gefunden.", vbInformation, "Keine Termine"
                Else
                    MsgBox "Bei der ausgewhlten Kategorie wurden im angegeben Zeitraum keine abrechenbaren Termine gefunden.", vbInformation, "Keine Termine"
                End If
            Else
                If (ReKategorie = 0) Then
                    MsgBox "Bei dem ausgewhlten Kunden wurden im angegeben Zeitraum keine abrechenbaren Termine gefunden.", vbInformation, "Keine Termine"
                Else
                    MsgBox "Bei dem ausgewhlten Kunden und der ausgewhlten Kategorie wurden im angegeben Zeitraum keine abrechenbaren Termine gefunden.", vbInformation, "Keine Termine"
                End If
            End If
        End If
        Exit Sub
    End If
    'Fortschrittsdialog auf den Schirm bringen
    stDocName = "Rechnungslauf"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    'Anzeigen fllen
    Forms!Rechnungslauf.Re_Termin_gesamt.Caption = rstTermine.RecordCount
    If ReLaufArt = 5 Then
        Forms!Rechnungslauf.Caption = "Kalkulationslauf..."
    Else
        Forms!Rechnungslauf.Caption = "Rechnungslauf..."
    End If
    ShowProgress Forms!Rechnungslauf.Verlauf_Balken, 1, 100
    NummeroGesamt = rstTermine.RecordCount
    NummeroTermin = 0
    ReNummer = " "
    ReKundeZuletzt = 0
    ReKalenderZuletzt = 0
    ReKategorieZuletzt = 0
    ReMonatZuletzt = 0
    ReGesamtNetto = 0
    RePositionen = 0
    ReDurchlauf = 0
    'Schema fr Rechnungsnummern; und allg. MwSt-Satz holen
    Set rstEinstellungen = dbs.OpenRecordset("Einstellungen")
        If (IsNull(rstEinstellungen!ReNr_Aufbau)) Then
            ReNummerSchema = "[JJJJ]######"
        Else
            If (Len(rstEinstellungen!ReNr_Aufbau) < 1) Then
                ReNummerSchema = "[JJJJ]######"
            Else
                ReNummerSchema = rstEinstellungen!ReNr_Aufbau
            End If
        End If
        If (IsNull(rstEinstellungen!MwSt_Standard)) Then
            ReMwStSatz_Standard = 0
        Else
            ReMwStSatz_Standard = rstEinstellungen!MwSt_Standard
        End If
    rstEinstellungen.Close
    'Tabellen ffnen (Testlauf - oder Normallauf)...
    ' 1) Rechnungstabelle ffnen
    If (ReTestlauf = True) Then
        Set rstRechnungen = dbs.OpenRecordset("ReTestlauf_Rechnungen")
        'alten Testlauf lschen
        If (rstRechnungen.RecordCount <> 0) Then rstRechnungen.MoveLast
        If (rstRechnungen.RecordCount > 0) Then
            rstRechnungen.MoveFirst
            Do While Not rstRechnungen.EOF
                rstRechnungen.Delete
                rstRechnungen.MoveNext
            Loop
        End If
    Else
        'kein Testlauf
        Set rstRechnungen = dbs.OpenRecordset("Rechnungen")
    End If
    ' 2) Rechnungsdetailtabelle ffnen
    If (ReTestlauf = True) Then
        Set rstRechnungsdetails = dbs.OpenRecordset("ReTestlauf_Rechnungsdetails")
        'alten Testlauf lschen
        If (rstRechnungsdetails.RecordCount <> 0) Then rstRechnungsdetails.MoveLast
        If (rstRechnungsdetails.RecordCount > 0) Then
            rstRechnungsdetails.MoveFirst
            Do While Not rstRechnungsdetails.EOF
                rstRechnungsdetails.Delete
                rstRechnungsdetails.MoveNext
            Loop
        End If
    Else
        'kein Testlauf
        Set rstRechnungsdetails = dbs.OpenRecordset("Rechnungsdetails")
    End If
    ' 3) Rechnungs-MwSt-Splitting Tabelle ffnen
    If (ReTestlauf = True) Then
        Set rstMwStSplitting = dbs.OpenRecordset("ReTestlauf_MwSt")
        'alten Testlauf lschen
        If (rstMwStSplitting.RecordCount <> 0) Then rstMwStSplitting.MoveLast
        If (rstMwStSplitting.RecordCount > 0) Then
            rstMwStSplitting.MoveFirst
            Do While Not rstMwStSplitting.EOF
                rstMwStSplitting.Delete
                rstMwStSplitting.MoveNext
            Loop
        End If
    Else
        'kein Testlauf
        Set rstMwStSplitting = dbs.OpenRecordset("Rechnungen_MwSt")
    End If
    ' 4) Text fr Abfrage zur Ermittlung der verwendeten MwSt-Stze bilden
    '    wird am Ende jeder Rechnung bentigt
    If (ReTestlauf = True) Then
        MwStSplittingTestTextVor = "SELECT ReTestlauf_Rechnungsdetails.MwSt_Satz," & _
                                   " Sum(ReTestlauf_Rechnungsdetails.Netto) AS SumNetto, Sum(ReTestlauf_Rechnungsdetails.km_Netto) AS SumKmNetto" & _
                                   " FROM ReTestlauf_Rechnungsdetails" & _
                                   " WHERE ReTestlauf_Rechnungsdetails.lfd_Nr_Re = "
        MwStSplittingTestTextNach = " GROUP BY ReTestlauf_Rechnungsdetails.MwSt_Satz" & _
                                    " ORDER BY ReTestlauf_Rechnungsdetails.MwSt_Satz;"
    Else
        MwStSplittingTestTextVor = "SELECT Rechnungsdetails.MwSt_Satz," & _
                                   " Sum(Rechnungsdetails.Netto) AS SumNetto, Sum(Rechnungsdetails.km_Netto) AS SumKmNetto" & _
                                   " FROM Rechnungsdetails" & _
                                   " WHERE Rechnungsdetails.lfd_Nr_Re = "
        MwStSplittingTestTextNach = " GROUP BY Rechnungsdetails.MwSt_Satz" & _
                                    " ORDER BY Rechnungsdetails.MwSt_Satz;"
    End If
    
    
    'Tabelle fr die Km-Preise ffnen
    '(wird ganz am Ende des Rechnungslaufes wieder geschlossen)
    FilterKmPreis = "SELECT * FROM Km_Preise ORDER BY gilt_ab DESC;"
    Set rstKmPreise = dbs.OpenRecordset(FilterKmPreis)
    If rstKmPreise.RecordCount <> 0 Then
        'Recordset auffllen
        rstKmPreise.MoveLast
        rstKmPreise.MoveFirst
    End If
    
    ' 1 Sekunde abziehen, damit die Anzeige zu Beginn garantiert akt. wird
    AktuelleZeit = Fix(Timer) - 1
    
    'alle gefundenen Termine durchgehen
    rstTermine.MoveFirst
    Do While Not rstTermine.EOF
        'Zhler und Anzeige aktualisieren
        NummeroTermin = NummeroTermin + 1
        ShowProgress Forms!Rechnungslauf.Verlauf_Balken, NummeroTermin - 1, NummeroGesamt
        Forms!Rechnungslauf.Re_Termin_aktuell.Caption = NummeroTermin
        Forms!Rechnungslauf.Re_Termindatum.Caption = rstTermine!Start
        'Start und Ende des Termins merken, um bei langen Terminen diese fr die Rechnungsdetails anpassen zu knnen
        ReDetailsTerminStart = rstTermine!Start
        ReDetailsTerminEnde = rstTermine!Ende
        ReDetailsTerminDauer = rstTermine!Dauer
        ReDetailsTerminAngepasst = False
        'Terminkalender fr die sptere Preisfindung merken
        ReAktTerminKalender = rstTermine!lfd_Nr_Kalender
        'Terminkategorie fr die sptere Preisfindung merken
        ReAktTerminKategorie = rstTermine!lfd_Nr_Kategorie
        'Nach Kontaktdetails suchen
        ReMwStSatz = ReMwStSatz_Standard
        ReKundePreisJeKategorie = False
        ReKundeMwStIndiv = False
        FilterKontakt = "SELECT * FROM Kunden WHERE [lfd_Nr] = " & rstTermine!lfd_Nr_Kunde
        Set rstKontakte = dbs.OpenRecordset(FilterKontakt)
            Forms!Rechnungslauf.Re_Kunde.Caption = rstKontakte!Name1
            'indiv. Gebuehren vorgesehen?
            If (rstKontakte!Gebuehr_indiv = True) Then
                ReGebuehrAllgemein = False
            Else
                ReGebuehrAllgemein = True
            End If
            'indiv. MwSt vorgesehen?
            If (rstKontakte!MwSt_indiv = True) Then
                ReKundeMwStIndiv = True
                If (IsNull(rstKontakte!MwSteuer)) Then
                    ReMwStSatz = 0
                Else
                    ReMwStSatz = rstKontakte!MwSteuer
                End If
            Else
                ReMwStSatz = ReMwStSatz_Standard
            End If
            'indiv. Berechnung nach Kategorien?
            ReKundePreisJeKategorie = rstKontakte!PreisJeKategorie_JaNein
        rstKontakte.Close
        'Jetzt prfen, ob die Terminkategorie eine idividuelle MwSt eingestellt hat und
        'ob diese Vorrang vor einer Kunden-MwSt-Einstellung hat
        '-------
        '  An dieser Stelle steht aktuell in ReMwStSatz entweder der allgemeine/zentrale Steuersatz oder
        '  bereits der indiv. Steuersatz des Kunden.
        '  ("Missbrauch" von rstKontakte)
        FilterKontakt = "SELECT * FROM Kategorien WHERE [lfd_Nr] = " & ReAktTerminKategorie
        Set rstKontakte = dbs.OpenRecordset(FilterKontakt)
        If rstKontakte.RecordCount > 0 Then
            '(eigentlich drfte nur genau ein Satz gefunden werden, aber man wei ja nie)
            rstKontakte.MoveLast                'auffllen
            rstKontakte.MoveFirst
            If rstKontakte!MwSt_indiv = True Then
                'Die Kategorie hat den Haken bei indiv. MwSt
                If ReKundeMwStIndiv = False Then
                    'der Kunde hat keine indiv. MwSt
                    'daher wird die MwSt der Kategorie zugewiesen
                    If (IsNull(rstKontakte!MwSteuer)) Then
                        ReMwStSatz = 0
                    Else
                        ReMwStSatz = rstKontakte!MwSteuer
                    End If
                Else
                    'der Kunde hat eine indiv. MwSt
                    If ReMwStPrioritaet = 0 Then                        ' 0 = Kunden-MwSt vor Kategorie vor Zentral
                        'Kunden-MwSt hat Prioritt vor Kategorie-MwSt
                        'daher wird ReMwStSatz NICHT verndert
                    Else
                        '---> falls weitere Werte als 0 und 1 mglich sind, muss statt ELSE auf ELSE IF geprft werden
                        'Kunden-MwSt hat KEINE Prioritt                ' 1 = Kategorie vor Kunde vor Zentral
                        If (IsNull(rstKontakte!MwSteuer)) Then
                            ReMwStSatz = 0
                        Else
                            ReMwStSatz = rstKontakte!MwSteuer
                        End If
                    End If
                End If
            End If
        End If
        rstKontakte.Close
        
        ReKunde = rstTermine!lfd_Nr_Kunde
        'ReKategorie = rstTermine!lfd_Nr_Kategorie
        
        'NEUE RECHNUNG und Re-Nummer generieren, wenn:
        'a) Kunde zum vorherigen Termin anders
        'oder
        'b) je Kategorie eine extra Rechnung erstellt werden soll und Kategorie zum vorherigen Termin anders
        If (ReKunde <> ReKundeZuletzt) Or ((ReJeKategorie = True) And (ReAktTerminKategorie <> ReKategorieZuletzt)) Then
            ReNeu = True                'neue Rechnung anlegen
            ReNeu2 = True               'fr Ermittlung des 1. tatschl. berechn. Termines bei neuer Rechnung
            RechnungsnummerGenerieren
        End If
        'wenn neue Rechnung erforderlich: gleich den Datensatz anlegen, da fr die Rechnungsdetails
        'die Datensatznummer der Rechnung bentigt wird
        If ReNeu = True Then
            'vorher noch prfen, ob letzte Rechnung gelscht werden kann,
            'da sie keine (null) Rechnungspositionen hat
            If (RePositionen = 0) And (ReDurchlauf > 0) Then
                rstRechnungen.Delete
                ReDurchlauf = ReDurchlauf - 1
                'eventuell noch die benutze laufende Nummer der Re-Nummer wieder freigeben/zurcksetzen,
                'aber nur, wenn die Rechnungsnummer eine laufende Nr. enthlt
                If (ReTestlauf = False) And (ReNr_Alt <> -1) Then
                    FilterReNummer = "SELECT * FROM Rechnungsnummern WHERE ([Jahr]=" & ReJahr & ")"
                    Set rstRechnungsnummern = dbs.OpenRecordset(FilterReNummer)
                    If (rstRechnungsnummern.RecordCount <> 0) Then
                        rstRechnungsnummern.Edit
                        rstRechnungsnummern!ReNr = ReNr_Alt
                        rstRechnungsnummern.Update
                    End If
                    rstRechnungsnummern.Close
                End If
            End If
            '--------------------------------------------------------------------------------------------------------
            '   Nun wird geprft, ob in der letzten Rechnung in den Positionen mehr als 1 MwSt-Satz vorhanden ist.
            '   Wenn ja, wird die MwSt-Splitting-Tabelle geschrieben, in der Rechnung das Splitting-Kennzeichen
            '   gesetzt und in die betroffenen Rechnungspositionen das Kennzeichen fr die jeweilige MwSt geschrieben.
            If (RePositionen > 0) And (ReDurchlauf > 0) Then
                MwSt_SplittingTest
            End If
            
            rstRechnungen.AddNew
                If (ReTestlauf = False) Then
                    rstRechnungen!lfd_Nr_ReLauf = rstRechnungslaeufe!lfd_Nr
                    If ReLaufArt = 4 Then                       'Marker fr Generalrckrechnung
                        rstRechnungen!Re_GRR = True
                    Else
                        rstRechnungen!Re_GRR = False
                    End If
                    'beim ersten mal, die Nummer als Startwert protokollieren
                    If ReDurchlauf = 0 Then
                        rstRechnungslaeufe.Edit
                        rstRechnungslaeufe!ReNr_von = ReNummer
                        rstRechnungslaeufe.Update
                        'zuletzt bearbeiteten Satz wieder zum aktuellen machen
                        rstRechnungslaeufe.Bookmark = rstRechnungslaeufe.LastModified
                    End If
                Else
                    rstRechnungen!lfd_Nr_ReLauf = 0
                End If
                rstRechnungen!lfd_Nr_Kunde = ReKunde
                If ReKategorie = 0 Then
                    rstRechnungen!lfd_Nr_Kategorie = SatzKategorieDummy
                Else
                    rstRechnungen!lfd_Nr_Kategorie = ReKategorie
                End If
                'Wenn die Rechnungen je Kategorie sein soll, kann die akt. Termin-Kategorie auch in den Rechnungseintrag
                If ReJeKategorie = True Then
                    rstRechnungen!lfd_Nr_Kategorie = ReAktTerminKategorie
                End If
                rstRechnungen!Re_Datum = ReDatumBenutzer
                    'alt: rstRechnungen!Re_Datum = Day(Now()) & "." & Month(Now()) & "." & Year(Now())
                rstRechnungen!Re_Nr = ReNummer
                rstRechnungen!Re_von = "01." & Format(ReMonatVon, "00") & "." & ReJahr
                'letzten Tag des Abrechnungszeitraumes ermitteln
                If ReMonatBis = 12 Then
                    rstRechnungen!Re_bis = "01.01." & (ReJahr + 1)                              'auf 1.1. des nchsten Jahres
                Else
                    rstRechnungen!Re_bis = "01." & Format(ReMonatBis + 1, "00") & "." & ReJahr  'auf den 1. des nchsten Monats
                End If
                rstRechnungen!Re_bis = rstRechnungen!Re_bis - 1                                 'der letzte Tag von Monat_bis
                rstRechnungen!Re_Jahr = ReJahr
                rstRechnungen!Re_Netto = 0
                rstRechnungen!MwSt_Satz = ReMwStSatz
                rstRechnungen!Re_MwSt = 0
                rstRechnungen!Re_Brutto = 0
                rstRechnungen!gedruckt = False
                rstRechnungen!MwSt_Splitting = False
            rstRechnungen.Update
            ReNeu = False
            RePositionen = 0
            ReGesamtNetto = 0
            ReDurchlauf = ReDurchlauf + 1
        End If
        'nach dem Speichern, den Datensatzzeiger wieder auf diesen Satz stellen
        rstRechnungen.Bookmark = rstRechnungen.LastModified
        'Anzeige neu zeichnen
        Forms!Rechnungslauf.Re_Rechnungsnummer.Caption = ReNummer
        If Fix(Timer) > AktuelleZeit Then                   'Eine Sekunde vergangen?
            'Anzeige aktualisieren
            Forms!Rechnungslauf.Repaint
            AktuelleZeit = Fix(Timer)
        End If
        'fr diesen Termin alle Abrechnungsmonate durchgehen
        'falls ReMonat < Terminbeginn, ReMonat an Terminbeginn anpassen
        ReMonat = ReMonatVon
        If (rstTermine!S_Jahr = ReJahr) And (rstTermine!S_Monat > ReMonat) Then
            ReMonat = rstTermine!S_Monat
        End If
        'Vor dem Durchlauf des Rechnungszeitraumes die folgende Zeile, damit je Termin die km nur
        'einmal ausgwiesen werden. Auch bei Monats-bergreifenden Terminen.
        ReKmRechnungszeile = False
        
        For ReMonat = ReMonat To ReMonatBis Step 1
            'Schleife verlassen, falls ReMonat > ReMonatBis
            '...nur sicherheitshalber, um Endlosschleifen zu vermeiden
            If (ReMonat > ReMonatBis) Then Exit For
            'Schleife verlassen, falls Terminende bereits erreicht
            If (rstTermine!E_Jahr = ReJahr) And (rstTermine!E_Monat < ReMonat) Then Exit For
            'Tabellen ffnen (Testlauf - oder Normallauf)...
            ' 3) Abgerechnete Daten ffnen
            FilterAbgerechnet = "SELECT * FROM Termine_berechnet WHERE (" & _
                "([Jahr] = " & ReJahr & ") AND ([Monat] = " & ReMonat & ")" & _
                " AND ([lfd_Nr_Termin] = " & rstTermine!lfd_Nr & "))"
            Set rstAbgerechnet = dbs.OpenRecordset(FilterAbgerechnet)
            ' 4) Kalkulierte Daten ffnen
            FilterKalkuliert = "SELECT * FROM Termine_kalkuliert WHERE (" & _
                "([Jahr] = " & ReJahr & ") AND ([Monat] = " & ReMonat & ")" & _
                " AND ([lfd_Nr_Termin] = " & rstTermine!lfd_Nr & "))"
            Set rstKalkuliert = dbs.OpenRecordset(FilterKalkuliert)
            'Marker setzen, damit nur tatschlich auf der Rechnung stehende Termine in der
            'Termintabelle mit Abrechnungsdaten befllt werden
            TerminIstBerechnet = False
            'eigentliche Berechnung ===================================================================
            If rstTermine!geloescht = True Then
                'wenn Termin gelscht wurde, bereits Berechnetes stornieren...
                If (rstAbgerechnet.RecordCount = 0) Then
                    'es gibt keinen Abrechnungssatz...
                    'Wenn der Termin gelscht wurde und fr den Monat kein Abrechnungssatz
                    'vorhanden ist, braucht er auch nicht auf der Rechnung erscheinen.
                    'Setzen der entgltigen Lschmarkierung weiter unten.
                Else
                    'es gibt einen Abrechnungssatz...
                    
                    
                    If ReTerminMonatssplitting = True Then
                        'wenn Termin-Beginn oder -Ende (oder beides) nicht im aktuellen Monat liegen,
                        '   dann Termin-START/-ENDE (sowie -DAUER) fr die Rechnungsdetails anpassen
                        '1)Termin-START prfen:
                        If (rstTermine!S_Jahr < ReJahr) Or ((rstTermine!S_Jahr = ReJahr) And (rstTermine!S_Monat < ReMonat)) Then
                            ReDetailsTerminStart = "01." & Format(ReMonat, "00") & "." & Format(ReJahr, "0000") & " 00:00:00"
                            ReDetailsTerminAngepasst = True
                        End If
                        '2)Termin-ENDE prfen:
                        'falls Termine ber mehrere Monate ging, aber in aktuellen Monat endet,
                        '   vorher das ursprngliche Endedatum zuordnen, da dies in der nachfolgenden
                        '   Bedingung nicht gendert wird
                        ReDetailsTerminEnde = rstTermine!Ende
                        If (rstTermine!E_Jahr > ReJahr) Or ((rstTermine!E_Jahr = ReJahr) And (rstTermine!E_Monat > ReMonat)) Then
                            'letzten Tag des Monats ermitteln
                            If ReMonat = 12 Then
                                ReDetailsTerminEnde = "01.01." & Format((ReJahr + 1), "0000") & " 00:00:00"                             'auf 1.1. des nchsten Jahres
                            Else
                                ReDetailsTerminEnde = "01." & Format(ReMonat + 1, "00") & "." & Format(ReJahr, "0000") & " 00:00:00"    'auf den 1. des nchsten Monats
                            End If
                                'Folgezeile deaktiviert, damit Zeitraum nicht fr 1 Sekunde unterbrochen ist
                                'ReDetailsTerminEnde = ReDetailsTerminEnde - 0.000012                                                   'der letzte Minute des akt. Monats
                            ReDetailsTerminAngepasst = True
                        End If
                        '3)Termin-DAUER berechnen:
                        If ReDetailsTerminAngepasst = True Then
                            If Second(ReDetailsTerminEnde) = 59 Then
                                '1 Sekunde dazu addieren, um bei 59 Sekunden die Minute voll zu machen,
                                'damit die Minutenanzahl z. B. beim Storno mit der Rechnung bereinstimmt
                                ReDetailsTerminDauer = DateDiff("n", ReDetailsTerminStart, (ReDetailsTerminEnde + 0.000012))
                            Else
                                ReDetailsTerminDauer = DateDiff("n", ReDetailsTerminStart, ReDetailsTerminEnde)
                            End If
                            ReDetailsTerminAngepasst = False
                        End If
                    End If      'von ReTerminMonatssplitting
                    
                    
                    'wenn Netto der Rechnungsposition <> 0 oder Netto der KM-Berechnung <> 0
                    '   (in diesem Falle ist das der bisher berechnete Betrag!)
                    If rstAbgerechnet!Netto <> 0 Or rstAbgerechnet!km_Netto <> 0 Then
                        'Rechnungsdetails schreiben
                        rstRechnungsdetails.AddNew
                        rstRechnungsdetails!lfd_Nr_Re = rstRechnungen!lfd_Nr
                        rstRechnungsdetails!Termin_ID = rstTermine!Termin_ID
                        rstRechnungsdetails!lfd_Nr_Termin = rstTermine!lfd_Nr
                        rstRechnungsdetails!Privat = rstTermine!Privat
                        rstRechnungsdetails!Start = ReDetailsTerminStart
                        rstRechnungsdetails!Ende = ReDetailsTerminEnde
                        rstRechnungsdetails!Dauer = ReDetailsTerminDauer
                            'alt: rstRechnungsdetails!Start = rstTermine!Start
                            'alt: rstRechnungsdetails!Ende = rstTermine!Ende
                            'alt: rstRechnungsdetails!Dauer = rstTermine!Dauer
                        rstRechnungsdetails!Betreff = rstTermine!Betreff
                        rstRechnungsdetails!geloescht = rstTermine!geloescht
                        rstRechnungsdetails!MMJJJJ_fuer_Re = "01." & Format(ReMonat, "00") & "." & ReJahr
                        rstRechnungsdetails!Dauer_fuer_Re = 0                       'da nichts BErechnet wird, also 0 (null)
                        rstRechnungsdetails!Std_Satz = 0                            'da nichts BErechnet wird, also 0 (null)
                        rstRechnungsdetails!Netto_bisher = rstAbgerechnet!Netto     'bisher fr diesen Monat insgesamt berechnet
                        rstRechnungsdetails!Netto = (rstAbgerechnet!Netto * -1)     'bisherige Abrechnungsdaten mit Vorzeichenwechsel
                        ' Der Termin wurde gelscht und bereits Berechnetes wird nun komplett zurck gerechnet:
                        ' --> MwSt_Kz und MwSt_Satz: Aktuelle Werte nehmen, oder historische Werte nehmen???
                        ' Bei einer Terminnderung wird ja immer mit den aktuellen Werten gerechnet.
                        rstRechnungsdetails!MwSt_Satz = ReMwStSatz
                        rstRechnungsdetails!MwSt_Kz = 1                 ' zunchst alle Rechnungspositionen mit "1" versehen
                        'Rechnungsdetails der km-Abrechnung
                        '   Bei Terminlschung die km-Abrechnung ebenfalls stornieren, egal welches
                        '   Abrechnungskennzeichen dafr gesetzt ist.
                        '   Ein bisheriges Netto fr km taucht nur im Monat des Terminbeginns auf,
                        '   da die km auf den Tag des Terminbeginns berechnet werden.
                        If rstAbgerechnet!km_Netto <> 0 Then
                            'wenn fr km ein Abrechnungswert vorliegt
                            rstRechnungsdetails!km_Netto_bisher = rstAbgerechnet!km_Netto   'bisher fr diesen Termin fr km berechnet
                            rstRechnungsdetails!km_Netto = (rstAbgerechnet!km_Netto * -1)   'bisherige Abrechnungsdaten mit Vorzeichenwechsel
                            rstRechnungsdetails!km_Anzahl = rstTermine!km_Anzahl            'die tatschlichen km ausweisen
                            rstRechnungsdetails!km_Preis = 0                                'da nichts BErechnet wird, also 0 (null)
                            rstRechnungsdetails!km_Text = km_RechText                       '  aktuelle Texte eintragen, da auch die Anzahl
                            rstRechnungsdetails!km_Einheit = km_TabellenKuerzel             '  sich auf die aktuellen Texte bezieht (normalerweise)
                        Else
                            'wenn fr km kein Abrechnungswert vorliegt, muss bei einem gelschten Termin
                            'auch nichtsberechnet werden, da der Termin ja nicht stattgefunden hat (eigentlich)
                            '  (auch kein Nachweis)
                            rstRechnungsdetails!km_Netto_bisher = 0
                            rstRechnungsdetails!km_Netto = 0
                            rstRechnungsdetails!km_Anzahl = 0
                            rstRechnungsdetails!km_Preis = 0
                            rstRechnungsdetails!km_Text = " "
                            rstRechnungsdetails!km_Einheit = " "
                        End If
                        'tatschlich berechnete von-/bis-Monate zur Rechnung vermerken
                        Re_von_bis_vermerken
                        'Nettobetrag merken
                        ReTerminNetto = (rstAbgerechnet!Netto * -1) + (rstAbgerechnet!km_Netto * -1)
                        rstRechnungsdetails.Update
                        'Da Termin nun auf der Rechnung steht, auch den Marker setzen, damit spter die Daten
                        'in die Termintabelle bernommen werden
                        TerminIstBerechnet = True
                        RePositionen = RePositionen + 1
                        ReGesamtNetto = ReGesamtNetto + ReTerminNetto
                        'wenn kein Testlauf, bisherige Abrechnungsdaten korrigieren
                        'ACHTUNG: Auch wenn die Korrektur 0,- EUR ergibt, den Datensatz stehen lassen,
                        '         da er eventuell fr ein Rechnungsstorno bentigt wird, was dann
                        '         eventuell einen Minusbetrag ergeben kann.
                        '         Beispiel: Ein Termin wird mit der ersten Rechnung berechnet, in Outlook
                        '                   gelscht und mit einer zweiten Rechnung gutgeschrieben.
                        '                   Nach der Gutschrift sind fr den Termin 0,- EUR als berechnet
                        '                   hinterlegt.
                        '                   Wird nun die erste Rechnung storniert, wird durch den Stornolauf
                        '                   ein negativer Betrag als berechnet eingetragen. Erst durch Storno
                        '                   des zweiten Rechnungslaufes (die eine Gutschrift ergab), wird der
                        '                   abgerechnete Betrag wieder auf 0,- gebracht.
                        If (ReTestlauf = False) Then
                            'beim Echtlauf werden die stornierten Betrge im Anschluss auf 0 gesetzt
                            If (TerminIstBerechnet = True) Then
                                'aber nur, wenn fr den Termin auch eine Rechnungszeile erstellt wurde
                                rstAbgerechnet.Edit
                                rstAbgerechnet!Netto = 0
                                rstAbgerechnet!km_Netto = 0
                                rstAbgerechnet.Update
                                'zuletzt bearbeiteten Satz wieder zum aktuellen machen
                                rstAbgerechnet.Bookmark = rstAbgerechnet.LastModified
                            End If
                        Else
                            If ReLaufArt = 5 Then
                                'beim Kalkulationslauf werden die stornierten Betrge im Anschluss in der Kalkulation auf 0 gesetzt
                                rstKalkuliert.Edit
                                rstKalkuliert!Netto = 0
                                rstKalkuliert!km_Netto = 0
                                rstKalkuliert.Update
                                'zuletzt bearbeiteten Satz wieder zum aktuellen machen
                                rstKalkuliert.Bookmark = rstKalkuliert.LastModified
                            End If
                        End If
                    End If      'Netto der Rechnungsposition <> 0?
                End If          'Abrechnungssatz forhanden?
            Else                'Termin gelscht?
                'wenn Termin nicht gelscht, normale Berechnung...
                'den fr diesen Monat bereits berechneten Preis ermitteln
                ReNettoBisher = 0
                ReKmNettoBisher = 0
                If (rstAbgerechnet.RecordCount <> 0) Then
                    ReNettoBisher = rstAbgerechnet!Netto
                    ReKmNettoBisher = rstAbgerechnet!km_Netto
                End If
                If ReLaufArt = 5 Then
                    If (rstKalkuliert.RecordCount <> 0) Then
                        ReNettoBisher = rstKalkuliert!Netto
                        ReKmNettoBisher = rstKalkuliert!km_Netto
                    End If
                End If
                'die fr diesen Abrechnungsmonat relevanten Minuten und Preis des Termines berechnen
                ReDauerBerechnet = 0
                ReStdSatzNetto = 0
                ReTerminNetto = 0
                ReKmNetto = 0
                ReKmNettoNeu = 0
                ReKmEinzPreis = 0
                'Folgende Zeile deaktiviert, da sonst bei Monats-bergreifendem Termin,
                'die km im Folgemonat nochmal ausgewiesen werden!
                        'ReKmRechnungszeile = False
                'Proceduren zur Matrixbearbeitung
                MatrixGebuehrenFuellen
                MatrixMinutenFuellen
                MatrixNettoFuellen
                MatrixRechnungslegung
            End If              'Termin gelscht?
            'Tabelle 'Berechnet' schlieen
            rstAbgerechnet.Close
            rstKalkuliert.Close
            'aktueller Termin: Netto/ReDatum/ReNummer/(berechnet/gendert_seit_Re)
            'des abgerechneten Wertes... aktualisieren (beides nur bei Normallauf)
            If (ReTestlauf = False) Then
                'akt. Abrechnungsbetrag zum Termin ermitteln
                ReTerminNetto = 0
                ReKmNetto = 0
                FilterAbgerechnet = "SELECT * FROM Termine_berechnet WHERE " & _
                    "([lfd_Nr_Termin] = " & rstTermine!lfd_Nr & ")"
                Set rstAbgerechnet = dbs.OpenRecordset(FilterAbgerechnet)
                If (rstAbgerechnet.RecordCount <> 0) Then rstAbgerechnet.MoveLast
                If rstAbgerechnet.RecordCount > 0 Then
                    Do While rstAbgerechnet.BOF = False
                        ReTerminNetto = ReTerminNetto + rstAbgerechnet!Netto
                        ReKmNetto = ReKmNetto + rstAbgerechnet!km_Netto
                        rstAbgerechnet.MovePrevious
                    Loop
                End If
                rstAbgerechnet.Close
                'Abrechnungsdaten zum Termin vermerken
                If TerminIstBerechnet = True Then
                    '...aber nur, wenn er tatschlich als Rechnungsposition hinterlegt ist
                    rstTermine.Edit
                    rstTermine!berechnet = True
                    rstTermine!geaendert_seit_Re = True                 'wird erst am Ende entfernt! s.u.
                    rstTermine!Su_Re_Netto = ReTerminNetto + ReKmNetto
                    rstTermine!Re_Datum = ReDatumBenutzer
                    rstTermine!Re_Nr = ReNummer
                    rstTermine.Update
                    'zuletzt bearbeiteten Satz wieder zum aktuellen machen
                    rstTermine.Bookmark = rstTermine.LastModified
                End If
            Else
                If ReLaufArt = 5 Then
                    'akt. Abrechnungsbetrag zum Termin ermitteln
                    ReTerminNetto = 0
                    ReKmNetto = 0
                    FilterKalkuliert = "SELECT * FROM Termine_kalkuliert WHERE " & _
                        "([lfd_Nr_Termin] = " & rstTermine!lfd_Nr & ")"
                    Set rstKalkuliert = dbs.OpenRecordset(FilterKalkuliert)
                    If (rstKalkuliert.RecordCount <> 0) Then rstKalkuliert.MoveLast
                    If rstKalkuliert.RecordCount > 0 Then
                        Do While rstKalkuliert.BOF = False
                            ReTerminNetto = ReTerminNetto + rstKalkuliert!Netto
                            ReKmNetto = ReKmNetto + rstKalkuliert!km_Netto
                            rstKalkuliert.MovePrevious
                        Loop
                    End If
                    rstKalkuliert.Close
                    'Abrechnungsdaten zum Termin vermerken
                    rstTermine.Edit
                    rstTermine!Su_Kalkulation = ReTerminNetto + ReKmNetto
                    rstTermine.Update
                    'zuletzt bearbeiteten Satz wieder zum aktuellen machen
                    rstTermine.Bookmark = rstTermine.LastModified
                End If
            End If
            'Rechnung: Netto/MwSt/Brutto aktualisieren
            '   Hinweis: mit CCur(Format(..)) wird die MwSt auf 2 Nachkommastellen gerundet,
            '   um "merkwrdige" Bruttobetrge zu verhindern, die durch die Addition der
            '   nicht sichtbaren 3. und 4. Nachkommastelle entstehen wrden.
            '--------------------------------------------------------------------------------------------------------
            '   Es folgt die alte bisherige Methode fr Rechnungen, auf denen nur 1 MwSt-Satz verwendet wird.
            '   Sie bildet die MwSt ber den bisher berechneten gesamten Nettobetrag; mit dem MwSt-Satz, der beim
            '   letzten Termin ermittelt wurde. Falls anschlieende Prfung nur die Verwendung eines Satzes ergibt,
            '   ist dies zufllig auch der Satz fr die gesamte Rechnung.
            rstRechnungen.Edit
                rstRechnungen!Re_Netto = ReGesamtNetto
                'ACHTUNG:
                'Rundung negativer Zahlen: wie positive Zahlen, das heit:
                'AUFrundung immer von der Null weg! ABrundung zur Null hin!
                'Negative Zahl erst positiv machen, dann runden und dann Minuszeichen davor.
                If ((ReGesamtNetto * ReMwStSatz) / 100) < 0 Then
                    rstRechnungen!Re_MwSt = CCur(Format((((ReGesamtNetto * ReMwStSatz) / 100) * (-1)), "#0.00")) * (-1)
                Else
                    rstRechnungen!Re_MwSt = CCur(Format(((ReGesamtNetto * ReMwStSatz) / 100), "#0.00"))
                End If
                rstRechnungen!Re_Brutto = rstRechnungen!Re_Netto + rstRechnungen!Re_MwSt
            rstRechnungen.Update
            'nach dem Speichern, den Datensatzzeiger wieder auf diesen Satz stellen...
            rstRechnungen.Bookmark = rstRechnungen.LastModified
            '...und Anzeige aktualisieren
            Forms!Rechnungslauf.Re_Betrag.Caption = Format(rstRechnungen!Re_Brutto, "#,##0.00")
            If Fix(Timer) > AktuelleZeit Then                   'Eine Sekunde vergangen?
                'Anzeige aktualisieren
                Forms!Rechnungslauf.Repaint
                AktuelleZeit = Fix(Timer)
            End If
            'Abrechnungsmonat merken
            ReMonatZuletzt = ReMonat
        Next ReMonat
        'wenn Termin als "gelscht" markiert und Termin komplett im Abrechnungszeitraum liegt,
        'Termin entgltig zum Lschen vorbereiten
        If (ReTestlauf = False) Then
            If rstTermine!S_Jahr = ReJahr Then
                If rstTermine!S_Monat >= ReMonatVon Then
                    If rstTermine!E_Monat <= ReMonatBis Then
                        rstTermine.Edit
                        rstTermine!geaendert_seit_Re = False
                        rstTermine.Update
                        'zuletzt bearbeiteten Satz wieder zum aktuellen machen
                        rstTermine.Bookmark = rstTermine.LastModified
                    End If
                End If
            End If
        End If
        'Kundennummer dieses Termines merken
        ReKundeZuletzt = ReKunde
        'ReKategorieZuletzt = ReKategorie
        ReKategorieZuletzt = ReAktTerminKategorie
        ReKalenderZuletzt = ReAktTerminKalender
        'nchster Termin
        rstTermine.MoveNext
    Loop                        'gefundene Termine durchgehen
    'prfen, ob letzte Rechnung gelscht werden kann,
    'da sie keine (null) Rechnungspositionen hat
    If (RePositionen = 0) And (ReDurchlauf > 0) Then
        rstRechnungen.Delete
        ReDurchlauf = ReDurchlauf - 1
        'eventuell noch die benutze laufende Nummer der Re-Nummer wieder freigeben/zurcksetzen,
        'aber nur, wenn die Rechnungsnummer eine laufende Nr. enthlt
        If (ReTestlauf = False) And (ReNr_Alt <> -1) Then
            FilterReNummer = "SELECT * FROM Rechnungsnummern WHERE ([Jahr]=" & ReJahr & ")"
            Set rstRechnungsnummern = dbs.OpenRecordset(FilterReNummer)
            If (rstRechnungsnummern.RecordCount <> 0) Then
                rstRechnungsnummern.Edit
                rstRechnungsnummern!ReNr = ReNr_Alt
                rstRechnungsnummern.Update
            End If
            rstRechnungsnummern.Close
        End If
    End If
    '--------------------------------------------------------------------------------------------------------
    '   Nun wird geprft, ob in der letzten Rechnung in den Positionen mehr als 1 MwSt-Satz vorhanden ist.
    '   Wenn ja, wird die MwSt-Splitting-Tabelle geschrieben, in der Rechnung das Splitting-Kennzeichen
    '   gesetzt und in die betroffenen Rechnungspositionen das Kennzeichen fr die jeweilige MwSt geschrieben.
    If (RePositionen > 0) And (ReDurchlauf > 0) Then
        MwSt_SplittingTest
    End If
    
    
    'Tabelle der Km-Preise wieder schliessen
    '(wurde ganz zu Beginn des Rechnungslaufes geffnet)
    rstKmPreise.Close
    
    'Fortschrittsdialog wieder schlieen
    DoCmd.Close acForm, "Rechnungslauf", acSaveYes
    'Tabellen schlieen
    rstMwStSplitting.Close
    rstRechnungsdetails.Close
    rstRechnungen.Close
    rstTermine.Close
    'bei Echtlauf und sofortigem Druck: Rechnungen jetzt drucken
    If (ReTestlauf = False) And ((ReLaufArt = 1) Or (ReLaufArt = 4)) Then
        If (ReDurchlauf > 0) Then
            RechnungenDrucken
        Else
            MsgBox "Im Rechnungslauf wurden keine Rechnungen generiert.", vbInformation, "Keine Rechnungen"
        End If
    End If
    
    '(nur bei Echtlauf!)
    If (ReTestlauf = False) Then
        'nicht mehr bentigte Termine lschen -----------------------------
        'Fortschrittsdialog anzeigen
        stDocName = "Outlook_einlesen"
        DoCmd.OpenForm stDocName, , , stLinkCriteria
        Forms!Outlook_einlesen.Pfeil_TermineLoeschen.Visible = True
        Forms!Outlook_einlesen.Jahresauswahl.Enabled = False
        Forms!Outlook_einlesen.Button_START.Enabled = False
        Forms!Outlook_einlesen.Button_STOP.Enabled = True
        Forms!Outlook_einlesen.Button_STOP.SetFocus
        Forms!Outlook_einlesen.Button_Schliessen.Enabled = False
        Forms!Outlook_einlesen.Repaint
        'Procedur ausfhren
        Termine_entfernen
        'Fortschrittsdialog schlieen
        DoCmd.Close acForm, "Outlook_einlesen", acSaveYes
        'Echtlauf protokollieren ----------------------------------------------
        'wenn im Lauf keine Rechnungen generiert wurden, den Eintrag wieder lschen, ansonsten aktualisieren
        If ReDurchlauf = 0 Then
            rstRechnungslaeufe.Delete
        Else
            rstRechnungslaeufe.Edit
            rstRechnungslaeufe!Ende = Now()
            rstRechnungslaeufe!ReNr_bis = ReNummer
            rstRechnungslaeufe!Re_Anzahl = ReDurchlauf
            rstRechnungslaeufe.Update
        End If
        rstRechnungslaeufe.Close
        'Hinweis, wenn Rechnungen ohne Drucken generiert wurden
        If ReLaufArt = 2 Then
            If (ReDurchlauf > 0) Then
                MsgBox "Die Rechnungen wurden generiert und in der Datenbank gespeichert. Sie knnen diese zu einem spteren Zeitpunkt ausdrucken.", vbOKOnly + vbInformation, "Hinweis"
            Else
                MsgBox "Im Rechnungslauf wurden keine Rechnungen generiert.", vbInformation, "Keine Rechnungen"
            End If
        End If
    End If
    
    'A C H T U N G
    'alle Tabellen komplett schlieen
    Set dbs = Nothing
    
    'bei Testlauf, diesen anzeigen (auer bei Kalkulationslauf)
    If (ReTestlauf = True) And (ReLaufArt <> 5) Then
        If (ReDurchlauf > 0) Then
        
                'Gre des Reportfensters und Berichts-Zoom optimieren
                'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
                AnwendungGroesseErmitteln
    
            stDocName = "ReTestlauf_Hauptformular"
            DoCmd.OpenReport stDocName, acViewPreview
            
                'Berichtsfenster nun auf Anwendungsgre zoomen
                DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe
                'Berichtsvorschau auf ganzes Blatt zoomen
                DoCmd.RunCommand acCmdFitToWindow
                
        Else
            MsgBox "Im Testlauf wurden keine Rechnungen generiert.", vbInformation, "Keine Rechnungen"
        End If
    End If

Rechnungslauf_Exit:
    Exit Sub
     
End Sub


